/*
 * Decompiled with CFR 0.152.
 */
package ru.dimgel.lib.web.core.request;

import ru.dimgel.lib.web._servlet3.HttpServletRequest3;
import ru.dimgel.lib.web._servlet3.HttpServletResponse3;
import ru.dimgel.lib.web.core.Main;
import ru.dimgel.lib.web.core.request.Method;
import ru.dimgel.lib.web.core.request.Method$;
import ru.dimgel.lib.web.core.request.Path;
import ru.dimgel.lib.web.core.request.Path$;
import ru.dimgel.lib.web.core.response.Response;
import ru.dimgel.lib.web.core.session.Session;
import ru.dimgel.lib.web.header.HeaderMap;
import ru.dimgel.lib.web.param.ParamMap;
import scala.None$;
import scala.NotNull;
import scala.Option;
import scala.ScalaObject;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestBackend
implements NotNull,
ScalaObject {
    private final HeaderMap.Immutable headers;
    private final ParamMap getParams;
    private final Path path;
    private final Method method;
    private final String baseUrl;
    private final String baseUri;
    private final HashSet<Session<?>> sessions;
    private Option<Response> response;
    private final HttpServletResponse3 servletResponse;
    private final HttpServletRequest3 servletRequest;
    private final Main main;

    public RequestBackend(Main main, HttpServletRequest3 servletRequest, HttpServletResponse3 servletResponse) {
        this.main = main;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.response = None$.MODULE$;
        this.sessions = new HashSet();
        String s = new StringBuilder().append((Object)main.config().context().servletContext().getContextPath()).append((Object)servletRequest.getServletPath()).toString();
        this.baseUri = s.endsWith("/") ? s : new StringBuilder().append((Object)s).append((Object)"/").toString();
        boolean ssl = servletRequest.isSecure();
        int port2 = servletRequest.getServerPort();
        this.baseUrl = new StringBuilder().append((Object)(ssl ? "https://" : "http://")).append((Object)servletRequest.getServerName()).append((Object)(ssl && port2 == 443 || !ssl && port2 == 80 ? "" : new StringBuilder().append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)port2)).toString())).append((Object)this.baseUri()).toString();
        this.method = Method$.MODULE$.apply(servletRequest.getMethod());
        this.path = Path$.MODULE$.apply(servletRequest.getPathInfo());
        this.getParams = main.config().factory().createParamMap_fromUrlEncoded(servletRequest.getQueryString());
        this.headers = main.config().factory().createHeaderMap(servletRequest);
    }

    public HeaderMap.Immutable headers() {
        return this.headers;
    }

    public ParamMap getParams() {
        return this.getParams;
    }

    public Path path() {
        return this.path;
    }

    public Method method() {
        return this.method;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public String baseUri() {
        return this.baseUri;
    }

    public HashSet<Session<?>> sessions() {
        return this.sessions;
    }

    public void response_$eq(Option<Response> option) {
        this.response = option;
    }

    public Option<Response> response() {
        return this.response;
    }

    public HttpServletResponse3 servletResponse() {
        return this.servletResponse;
    }

    public HttpServletRequest3 servletRequest() {
        return this.servletRequest;
    }

    public Main main() {
        return this.main;
    }
}

