/*
 * Copyright 2014 dmerkushov.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ru.dmerkushov.loghelper.configure.loggerwrapper;

import org.w3c.dom.Node;
import ru.dmerkushov.loghelper.LogHelperDebug;
import ru.dmerkushov.loghelper.LoggerWrapper;

/**
 *
 * @author Dmitriy Merkushov
 */
public class FallbackToConsoleConfigurator extends WrappingConfigurator {
	
	public FallbackToConsoleConfigurator (LoggerWrapper loggerWrapper, Node configuration) {
		super (loggerWrapper, configuration);
	}

	@Override
	public boolean configure () {
		boolean wrappedSuccess = getWrappedConfigurator ().configure ();
				
		if (!wrappedSuccess) {
			LogHelperDebug.printError ("Could not configure LoggerWrapper with the wrapped configurator, " + getWrappedConfigurator ().getClass ().getCanonicalName () + ". Will fallback to console", wrappedSuccess);
			ConsoleConfigurator consoleConfigurator = new ConsoleConfigurator (loggerWrapper, configuration);
			consoleConfigurator.configure ();
		} else {
			LogHelperDebug.printError ("The wrapped configurator, " + getWrappedConfigurator ().getClass ().getCanonicalName () + ", has succesfully configured the LoggerWrapper. Will not fallback to console", wrappedSuccess);
		}
		
		return true;
	}

}
