/*
 * Decompiled with CFR 0.152.
 */
package ru.dmerkushov.oshelper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ru.dmerkushov.oshelper.OSHelperException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSHelper {
    public static final int osh_PROCESS_EXITED_BY_ITSELF = 1;
    public static final int osh_PROCESS_KILLED_BY_TIMEOUT = 2;

    public static Process runCommand(List<String> toRun) throws OSHelperException {
        Process proc;
        ProcessBuilder procBuilder = new ProcessBuilder(new String[0]);
        procBuilder.command(toRun);
        try {
            proc = procBuilder.start();
        }
        catch (IOException ex) {
            throw new OSHelperException("Received an IOException when running command:\n" + toRun + "\n" + ex.getMessage(), ex);
        }
        return proc;
    }

    public static ProcessReturn procWaitWithProcessReturn(Process process) throws OSHelperException {
        ProcessReturn processReturn = new ProcessReturn();
        try {
            processReturn.exitCode = process.waitFor();
        }
        catch (InterruptedException ex) {
            throw new OSHelperException("Received an InterruptedException when waiting for an external process to terminate.", ex);
        }
        InputStream stdoutIs = process.getInputStream();
        processReturn.stdout = OSHelper.readInputStreamAsString(stdoutIs);
        InputStream stderrIs = process.getErrorStream();
        processReturn.stderr = OSHelper.readInputStreamAsString(stderrIs);
        processReturn.exitStatus = 1;
        return processReturn;
    }

    public static ProcessReturn procWaitWithProcessReturn(Process process, long timeout) throws OSHelperException {
        InputStream stderrIs;
        InputStream stdoutIs;
        long endTime = Calendar.getInstance().getTimeInMillis() + timeout;
        boolean terminatedByItself = false;
        ProcessReturn processReturn = new ProcessReturn();
        while (Calendar.getInstance().getTimeInMillis() < endTime) {
            try {
                stdoutIs = process.getInputStream();
                processReturn.stdout = OSHelper.readInputStreamAsString(stdoutIs);
                stderrIs = process.getErrorStream();
                processReturn.stderr = OSHelper.readInputStreamAsString(stderrIs);
                processReturn.exitCode = process.exitValue();
                processReturn.exitStatus = 1;
                terminatedByItself = true;
            }
            catch (IllegalThreadStateException ex) {
                terminatedByItself = false;
            }
            if (!terminatedByItself) continue;
        }
        if (!terminatedByItself) {
            process.destroy();
            try {
                stdoutIs = process.getInputStream();
                processReturn.stdout = OSHelper.readInputStreamAsString(stdoutIs);
                stderrIs = process.getErrorStream();
                processReturn.stderr = OSHelper.readInputStreamAsString(stderrIs);
                processReturn.exitCode = process.waitFor();
            }
            catch (InterruptedException ex) {
                throw new OSHelperException(ex);
            }
            processReturn.exitStatus = 2;
        }
        return processReturn;
    }

    public static int procWait(Process process) throws OSHelperException {
        try {
            return process.waitFor();
        }
        catch (InterruptedException ex) {
            throw new OSHelperException("Received an InterruptedException when waiting for an external process to terminate.", ex);
        }
    }

    public static int procWait(Process process, long timeout) throws OSHelperException {
        long endTime = Calendar.getInstance().getTimeInMillis() + timeout;
        boolean terminatedByItself = false;
        int toReturn = 0;
        while (Calendar.getInstance().getTimeInMillis() < endTime) {
            try {
                process.exitValue();
                terminatedByItself = true;
                toReturn = 1;
            }
            catch (IllegalThreadStateException ex) {
                terminatedByItself = false;
            }
            if (!terminatedByItself) continue;
        }
        if (!terminatedByItself) {
            process.destroy();
            try {
                process.waitFor();
            }
            catch (InterruptedException ex) {
                throw new OSHelperException(ex);
            }
            toReturn = 2;
        }
        return toReturn;
    }

    public static byte[] readFile(String fileName) throws OSHelperException {
        long fileLengthLong;
        File file = new File(fileName);
        if (!file.exists()) {
            throw new OSHelperException("File " + fileName + " does not exist");
        }
        if (!file.canRead()) {
            throw new OSHelperException("File " + fileName + " is not readable");
        }
        if (!file.isFile()) {
            throw new OSHelperException("File " + fileName + " is not a normal file");
        }
        RandomAccessFile raFile = null;
        try {
            raFile = new RandomAccessFile(fileName, "r");
        }
        catch (FileNotFoundException ex) {
            throw new OSHelperException("File " + fileName + " not found");
        }
        try {
            fileLengthLong = raFile.length();
        }
        catch (IOException ex) {
            throw new OSHelperException(ex);
        }
        if (fileLengthLong > Integer.MAX_VALUE) {
            throw new OSHelperException("File length exceeds 2147483647 bytes: " + fileLengthLong);
        }
        int fileLengthInt = (int)fileLengthLong;
        byte[] bytes = new byte[fileLengthInt];
        try {
            raFile.read(bytes);
        }
        catch (IOException ex) {
            throw new OSHelperException(ex);
        }
        finally {
            try {
                raFile.close();
            }
            catch (IOException ex) {
                throw new OSHelperException(ex);
            }
        }
        return bytes;
    }

    public static void writeFile(byte[] bytes, String targetFileName) throws OSHelperException {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(targetFileName);
        }
        catch (FileNotFoundException ex) {
            throw new OSHelperException("Received a FileNotFoundException when trying to open target file " + targetFileName + ".", ex);
        }
        try {
            fos.write(bytes);
        }
        catch (IOException ex) {
            throw new OSHelperException("Received an IOException when trying to write to target file " + targetFileName + ".", ex);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                throw new OSHelperException("Received an IOException when trying to close FileOutputStream for target file " + targetFileName + ".", ex);
            }
        }
    }

    public static void copyFile(String sourceFileName, String targetFileName) throws OSHelperException {
        FileWriter targetWriter;
        FileReader sourceReader;
        File sourceFile = new File(sourceFileName);
        File targetFile = new File(targetFileName);
        try {
            sourceReader = new FileReader(sourceFile);
        }
        catch (FileNotFoundException ex) {
            throw new OSHelperException("Received an FileNotFoundException when trying to open source file " + sourceFileName + ".", ex);
        }
        try {
            targetWriter = new FileWriter(targetFile);
        }
        catch (IOException ex) {
            throw new OSHelperException("Received an IOException when trying to open target file " + targetFileName + ".", ex);
        }
        int readByteInInt = 0;
        while (readByteInInt != -1) {
            try {
                readByteInInt = sourceReader.read();
            }
            catch (IOException ex) {
                throw new OSHelperException("Received an IOException when trying to read from source file " + sourceFileName + ".", ex);
            }
            if (readByteInInt == -1) continue;
            try {
                targetWriter.write(readByteInInt);
            }
            catch (IOException ex) {
                throw new OSHelperException("Received an IOException when trying to write to target file " + targetFileName + ".", ex);
            }
        }
        try {
            sourceReader.close();
        }
        catch (IOException ex) {
            throw new OSHelperException("Received an IOException when trying to close reader for source file " + sourceFileName + ".", ex);
        }
        try {
            targetWriter.close();
        }
        catch (IOException ex) {
            throw new OSHelperException("Received an IOException when trying to close reader for target file " + targetFileName + ".", ex);
        }
    }

    public static ProcessReturn sendEmail_Unix(String target, String topic, String text) throws OSHelperException {
        topic = topic.replaceAll("\"", "\\\"");
        String emailCommandAsString = "mail -s \"" + topic + "\" -S sendcharsets=utf-8 " + target;
        List<String> emailCommandAsList = OSHelper.constructCommandAsList_Unix_sh(emailCommandAsString);
        Process process = OSHelper.runCommand(emailCommandAsList);
        OutputStream processStdin = process.getOutputStream();
        try {
            processStdin.write(text.getBytes());
        }
        catch (IOException ex) {
            throw new OSHelperException(ex);
        }
        try {
            processStdin.close();
        }
        catch (IOException ex) {
            throw new OSHelperException(ex);
        }
        ProcessReturn processReturn = OSHelper.procWaitWithProcessReturn(process, 10000L);
        return processReturn;
    }

    public static List<String> constructCommandAsList_Unix_sh(String command) {
        ArrayList<String> commandAsList = new ArrayList<String>();
        commandAsList.add("sh");
        commandAsList.add("-c");
        commandAsList.add(command);
        return commandAsList;
    }

    public static List<String> constructCommandAsList_Windows_cmd(String command) {
        ArrayList<String> commandAsList = new ArrayList<String>();
        commandAsList.add("cmd");
        commandAsList.add("/c");
        commandAsList.add(command);
        return commandAsList;
    }

    private static String readInputStreamAsString(InputStream is) throws OSHelperException {
        int availableBytes;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            availableBytes = is.available();
        }
        catch (IOException ex) {
            if (ex.getMessage() != null && ex.getMessage().startsWith("Stream closed")) {
                return null;
            }
            throw new OSHelperException(ex);
        }
        while (availableBytes > 0) {
            try {
                baos.write(is.read());
            }
            catch (IOException ex) {
                throw new OSHelperException(ex);
            }
            try {
                availableBytes = is.available();
            }
            catch (IOException ex) {
                if (ex.getMessage() != null && ex.getMessage().startsWith("Stream closed")) {
                    return null;
                }
                throw new OSHelperException(ex);
            }
        }
        return baos.toString();
    }

    public static class ProcessReturn {
        public static final int osh_PROCESS_EXITED_BY_ITSELF = 1;
        public static final int osh_PROCESS_KILLED_BY_TIMEOUT = 2;
        public int exitStatus;
        public int exitCode;
        public String stdout;
        public String stderr;
    }
}

