/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.example;

import java.math.BigDecimal;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import ru.fix.completable.reactor.example.Flow;
import ru.fix.completable.reactor.example.PurchasePayload;
import ru.fix.completable.reactor.example.services.Bank;
import ru.fix.completable.reactor.example.services.MarketingService;
import ru.fix.completable.reactor.example.services.Notifier;
import ru.fix.completable.reactor.example.services.ServiceRegistry;
import ru.fix.completable.reactor.example.services.TransactionLog;
import ru.fix.completable.reactor.example.services.UserJournal;
import ru.fix.completable.reactor.example.services.UserProfileManager;
import ru.fix.completable.reactor.graph.Graph;
import ru.fix.completable.reactor.graph.Graphable;
import ru.fix.completable.reactor.graph.Vertex;
import ru.fix.completable.reactor.runtime.CompletableReactor;

@Configuration
public class PurchaseGraph
extends Graph<PurchasePayload> {
    @Autowired
    UserProfileManager userProfileManager;
    @Autowired
    TransactionLog transactionLog;
    @Autowired
    UserJournal userJournal;
    @Autowired
    Notifier notifier;
    @Autowired
    Bank bank;
    @Autowired
    ServiceRegistry serviceRegistry;
    @Autowired
    MarketingService marketingService;
    @Autowired
    CompletableReactor completableReactor;
    Vertex loadUserProfile = this.handler(pld -> this.userProfileManager.loadUserProfileById(pld.request.getUserId())).withRoutingMerger((pld, result) -> {
        if (pld.response.getStatus() != null) {
            return Flow.STOP;
        }
        switch (result.status) {
            case USER_NOT_FOUND: 
            case USER_IS_BLOCKED: {
                pld.response.setStatus(result.status);
                return Flow.STOP;
            }
            case OK: {
                pld.intermediateData.setUserInfo(result.userProfile);
                return Flow.CONTINUE;
            }
        }
        throw new IllegalArgumentException("result.status = " + result.status);
    });
    Vertex logTransaction = this.logTransaction();
    Vertex logTransaction2 = this.logTransaction();
    Vertex logActionToUserJournal = this.handler(pld -> this.userJournal.logAction(pld.request.getUserId(), String.format("Request type: %s", pld.getClass().getSimpleName()))).withoutMerger();
    Vertex sendWebNotification = this.handler(pld -> this.notifier.sendHttpPurchaseNotification(pld.request.getUserId())).withoutMerger();
    Vertex sendSmsNotification = this.handler(pld -> this.notifier.sendSmsPurchaseNotification(pld.request.getUserId())).withoutMerger();
    Vertex withdrawMoneyWithMinus = this.handler(pld -> this.bank.withdrawMoneyWithMinus(pld.intermediateData.getUserInfo(), pld.intermediateData.getServiceInfo())).withRoutingMerger((pld, withdraw) -> {
        switch (withdraw.getStatus()) {
            case WALLET_NOT_FOUND: 
            case USER_IS_BLOCKED: {
                pld.response.setStatus(withdraw.getStatus());
                return Flow.STOP;
            }
            case OK: {
                pld.response.setNewAmount(withdraw.getNewAmount()).setWithdrawalWasInMinus(withdraw.getNewAmount().compareTo(BigDecimal.ZERO) < 0).setStatus(Bank.Withdraw.Status.OK);
                return Flow.CONTINUE;
            }
        }
        throw new IllegalArgumentException("Status: " + withdraw.getStatus());
    });
    Vertex isPartnerService = this.mutator(pld -> {
        if (pld.intermediateData.serviceInfo.isPartnerService()) {
            pld.response.isPartnerService = true;
        }
    });
    Vertex loadServiceInfo = this.handler(pld -> this.serviceRegistry.loadServiceInformation(pld.request.getServiceId())).withRoutingMerger((pld, result) -> {
        if (pld.response.getStatus() != null) {
            return Flow.STOP;
        }
        switch (result.getStatus()) {
            case SERVICE_NOT_FOUND: {
                pld.response.setStatus(result.getStatus());
                return Flow.STOP;
            }
            case OK: {
                pld.intermediateData.setServiceInfo(result.getServiceInfo());
                if (result.getServiceInfo().isActive()) {
                    return Flow.WITHDRAWAL;
                }
                return Flow.NO_WITHDRAWAL;
            }
        }
        return Flow.CONTINUE;
    });
    Vertex checkBonuses = this.router(pld -> {
        Optional<Long> bonus = this.marketingService.checkBonuses(pld.request.userId, pld.request.serviceId);
        if (bonus.isPresent()) {
            pld.intermediateData.bonusService = bonus.get();
            return Flow.BONUS_EXIST;
        }
        return Flow.NO_BONUS;
    });
    Vertex bonusPurchaseSubgraph = this.subgraph(PurchasePayload.class, pld -> {
        PurchasePayload subgraphRequest = new PurchasePayload();
        subgraphRequest.request.setServiceId(107L).setUserId(pld.request.userId);
        return subgraphRequest;
    }).withMerger((pld, subgraphResult) -> {
        pld.response.bonusServiceStatus = subgraphResult.response.status;
    });

    public PurchaseGraph() {
        this.payload().handleBy(this.loadUserProfile).handleBy(this.loadServiceInfo);
        this.loadUserProfile.on((Enum)Flow.STOP).complete().on((Enum)Flow.CONTINUE).mergeBy(this.loadServiceInfo);
        this.loadServiceInfo.on((Enum)Flow.WITHDRAWAL).handleBy(this.withdrawMoneyWithMinus).on((Enum)Flow.NO_WITHDRAWAL).handleBy(this.logTransaction2).on((Enum)Flow.NO_WITHDRAWAL).handleBy(this.sendWebNotification).on((Enum)Flow.NO_WITHDRAWAL).handleBy(this.sendSmsNotification).on((Enum)Flow.STOP).complete();
        this.withdrawMoneyWithMinus.onAny().handleBy(this.isPartnerService);
        this.isPartnerService.onAny().handleBy(this.logTransaction);
        this.logTransaction.onAny().handleBy(this.logActionToUserJournal);
        this.logTransaction2.onAny().handleBy(this.logActionToUserJournal);
        this.logActionToUserJournal.onAny().handleBy(this.checkBonuses);
        this.checkBonuses.on((Enum)Flow.BONUS_EXIST).handleBy(this.bonusPurchaseSubgraph).on((Enum)Flow.NO_BONUS).complete();
        this.bonusPurchaseSubgraph.onAny().complete();
        this.coordinates().pd(495, 34).vx(this.bonusPurchaseSubgraph, 309, 917).vx(this.checkBonuses, 595, 806).vx(this.isPartnerService, 376, 513).vx(this.sendSmsNotification, 823, 392).vx(this.sendWebNotification, 926, 333).vx(this.loadServiceInfo, 565, 96, 643, 232).vx(this.loadUserProfile, 734, 97, 737, 160).vx(this.logActionToUserJournal, 554, 694, 593, 757).vx(this.logTransaction, 434, 586, 464, 658).vx(this.logTransaction2, 700, 481, 719, 551).vx(this.withdrawMoneyWithMinus, 349, 377, 378, 441).ct(this.checkBonuses, 775, 934).ct(this.loadServiceInfo, 497, 293).ct(this.loadUserProfile, 897, 225);
    }

    @PostConstruct
    public void initialize() {
        this.completableReactor.registerGraphIfAbsent((Graphable)this);
    }

    Vertex logTransaction() {
        return this.handler(pld -> this.transactionLog.logTransactioin(pld.request.getUserId())).withoutMerger();
    }
}

