/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.example.flight.ticket;

import ru.fix.completable.reactor.example.flight.ticket.Bank;
import ru.fix.completable.reactor.example.flight.ticket.BuyFightTicketPayload;
import ru.fix.completable.reactor.example.flight.ticket.EmailClient;
import ru.fix.completable.reactor.example.flight.ticket.FlightPlanner;
import ru.fix.completable.reactor.example.flight.ticket.SalesDepartment;
import ru.fix.completable.reactor.graph.Graph;
import ru.fix.completable.reactor.graph.Vertex;

public class BuyFlightTicketGraph
extends Graph<BuyFightTicketPayload> {
    SalesDepartment salesDepartment = new SalesDepartment();
    Bank bank = new Bank();
    EmailClient emailClient = new EmailClient();
    FlightPlanner flightPlanner = new FlightPlanner();
    Vertex askForPrice = this.handler(payload -> this.salesDepartment.calculateCurrentPrice(payload.request.destination)).withMerger((payload, currentPrice) -> {
        payload.intermediateData.price = currentPrice;
    });
    Vertex reserveSeat = this.handler(payload -> this.flightPlanner.reserveSeat()).withRoutingMerger((payload, isSeatReserved) -> {
        if (!isSeatReserved.booleanValue()) {
            payload.response.operationResult = "Seat reservation failed";
            return Flow.DENY_PURCHASE;
        }
        return Flow.SEAT_RESERVED;
    });
    Vertex withdrawMoney = this.handler(payload -> this.bank.withdrawMoney(payload.intermediateData.price)).withRoutingMerger((payload, withdrawSuccessful) -> {
        if (withdrawSuccessful.booleanValue()) {
            payload.response.operationResult = "Successful purchase for " + payload.intermediateData.price;
            return Flow.SUCCESS_WITHDRAW;
        }
        payload.response.operationResult = "Money withdraw failed";
        return Flow.DENY_PURCHASE;
    });
    Vertex sendDenyEmail = this.handler(payload -> this.emailClient.sendEmail("Sorry, can not purchase a ticket.")).withoutMerger();
    Vertex sendSuccessEmail = this.handler(payload -> this.emailClient.sendEmail("Congratulations, you have purchased a ticket.")).withoutMerger();

    public BuyFlightTicketGraph() {
        this.payload().handleBy(this.askForPrice).handleBy(this.reserveSeat);
        this.reserveSeat.on((Enum)Flow.DENY_PURCHASE).complete().on((Enum)Flow.SEAT_RESERVED).mergeBy(this.askForPrice);
        this.askForPrice.onAny().handleBy(this.withdrawMoney);
        this.withdrawMoney.on((Enum)Flow.SUCCESS_WITHDRAW).handleBy(this.sendSuccessEmail).on((Enum)Flow.DENY_PURCHASE).handleBy(this.sendDenyEmail);
        this.sendSuccessEmail.onAny().complete();
        this.sendDenyEmail.onAny().complete();
        this.coordinates().pd(89, -126).vx(this.askForPrice, 219, -60, 205, 45).vx(this.reserveSeat, 18, -60, 90, 12).vx(this.sendDenyEmail, 6, 304, 54, 368).vx(this.sendSuccessEmail, 248, 309, 312, 369).vx(this.withdrawMoney, 116, 145, 113, 218).ct(this.reserveSeat, -67, 66).ct(this.sendDenyEmail, 47, 420).ct(this.sendSuccessEmail, 308, 419);
    }

    static enum Flow {
        DENY_PURCHASE,
        SEAT_RESERVED,
        SUCCESS_WITHDRAW;

    }
}

