/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.example.services;

import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import ru.fix.completable.reactor.example.services.ServiceInfo;
import ru.fix.completable.reactor.example.services.UserProfile;

public class Bank {
    final Map<Long, AtomicReference<BigDecimal>> wallets = new ConcurrentHashMap<Long, AtomicReference<BigDecimal>>();

    public Bank() {
        this.wallets.put(1L, new AtomicReference<BigDecimal>(BigDecimal.valueOf(1000.0)));
        this.wallets.put(2L, new AtomicReference<BigDecimal>(BigDecimal.valueOf(1000.0)));
    }

    public CompletableFuture<Withdraw> withdrawMoney(UserProfile userProfile, ServiceInfo serviceInfo) {
        return CompletableFuture.supplyAsync(() -> {
            AtomicReference<BigDecimal> wallet = this.wallets.get(userProfile.userId);
            if (wallet == null) {
                return new Withdraw().setStatus(Withdraw.Status.WALLET_NOT_FOUND);
            }
            if (userProfile.isBlocked) {
                return new Withdraw().setStatus(Withdraw.Status.USER_IS_BLOCKED);
            }
            return new Withdraw().setNewAmount(wallet.accumulateAndGet(serviceInfo.servicePrice, (prevValue, arg) -> {
                BigDecimal newValue = prevValue.add(arg.negate());
                return newValue.compareTo(BigDecimal.ZERO) > 0 ? newValue : prevValue;
            })).setUserId(userProfile.userId).setStatus(Withdraw.Status.OK);
        });
    }

    public CompletableFuture<Withdraw> withdrawMoneyWithMinus(UserProfile userProfile, ServiceInfo serviceInfo) {
        return CompletableFuture.supplyAsync(() -> {
            AtomicReference<BigDecimal> wallet = this.wallets.get(userProfile.userId);
            if (wallet == null) {
                return new Withdraw().setStatus(Withdraw.Status.WALLET_NOT_FOUND);
            }
            if (userProfile.isBlocked) {
                return new Withdraw().setStatus(Withdraw.Status.USER_IS_BLOCKED);
            }
            return new Withdraw().setNewAmount(wallet.accumulateAndGet(serviceInfo.servicePrice, (prev, arg) -> prev.add(arg.negate()))).setUserId(userProfile.userId).setStatus(Withdraw.Status.OK);
        });
    }

    public static class Withdraw {
        Long userId;
        Status status;
        BigDecimal newAmount;

        public Long getUserId() {
            return this.userId;
        }

        public Withdraw setUserId(Long userId) {
            this.userId = userId;
            return this;
        }

        public Status getStatus() {
            return this.status;
        }

        public Withdraw setStatus(Status status) {
            this.status = status;
            return this;
        }

        public BigDecimal getNewAmount() {
            return this.newAmount;
        }

        public Withdraw setNewAmount(BigDecimal newAmount) {
            this.newAmount = newAmount;
            return this;
        }

        public static enum Status {
            OK,
            USER_IS_BLOCKED,
            WALLET_NOT_FOUND;

        }
    }
}

