/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.example.services;

import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.fix.completable.reactor.example.services.ServiceInfo;

public class ServiceRegistry {
    public static final long SERVICE_ID_CAR_WASH = 1L;
    public static final long SERVICE_ID_HAIR_CUT = 2L;
    public static final long SERVICE_ID_INVALID = 3L;
    final Map<Long, ServiceInfo> services = Stream.of(new ServiceInfo().setServiceId(1L).setServiceName("Car wash").setServicePrice(BigDecimal.valueOf(10.0)).setActive(true), new ServiceInfo().setServiceId(2L).setServiceName("Heir cut").setServicePrice(BigDecimal.valueOf(3.15)).setActive(false)).collect(Collectors.toMap(service -> service.serviceId, Function.identity()));

    public CompletableFuture<ServiceInfoResult> loadServiceInformation(Long serviceId) {
        return CompletableFuture.supplyAsync(() -> this.services.get(serviceId)).thenApplyAsync(service -> {
            if (service == null) {
                return new ServiceInfoResult().setStatus(Status.SERVICE_NOT_FOUND);
            }
            return new ServiceInfoResult().setServiceInfo((ServiceInfo)service).setStatus(Status.OK);
        });
    }

    public static class ServiceInfoResult {
        Status status;
        ServiceInfo serviceInfo;

        public Status getStatus() {
            return this.status;
        }

        public ServiceInfoResult setStatus(Status status) {
            this.status = status;
            return this;
        }

        public ServiceInfo getServiceInfo() {
            return this.serviceInfo;
        }

        public ServiceInfoResult setServiceInfo(ServiceInfo serviceInfo) {
            this.serviceInfo = serviceInfo;
            return this;
        }
    }

    public static enum Status {
        SERVICE_NOT_FOUND,
        OK;

    }
}

