/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.stdlib.id.generator;

import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.fix.stdlib.id.generator.BitsConfiguration;
import ru.fix.stdlib.id.generator.IdGenerator;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lru/fix/stdlib/id/generator/AtomicIdGenerator;", "Lru/fix/stdlib/id/generator/IdGenerator;", "bitsConfig", "Lru/fix/stdlib/id/generator/BitsConfiguration;", "startOfTime", "", "serverId", "clock", "Ljava/time/Clock;", "(Lru/fix/stdlib/id/generator/BitsConfiguration;JJLjava/time/Clock;)V", "id", "Ljava/util/concurrent/atomic/AtomicLong;", "serverIdPart", "buildIdForNewTimestampWithZeroCounter", "timeValue", "extractCounterPart", "extractPart", "shiftBits", "", "mask", "extractServerIdPart", "extractTimePart", "nextId", "timeFromId", "idValue", "Companion", "jfix-stdlib-id-generator"})
public final class AtomicIdGenerator
implements IdGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BitsConfiguration bitsConfig;
    private final long startOfTime;
    @NotNull
    private final Clock clock;
    @NotNull
    private final AtomicLong id;
    private final long serverIdPart;

    public AtomicIdGenerator(@NotNull BitsConfiguration bitsConfig, long startOfTime, long serverId, @NotNull Clock clock) {
        long l;
        Intrinsics.checkNotNullParameter((Object)bitsConfig, (String)"bitsConfig");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.bitsConfig = bitsConfig;
        this.startOfTime = startOfTime;
        this.clock = clock;
        this.serverIdPart = serverId;
        boolean bl = 0L <= serverId ? serverId <= this.bitsConfig.getServerPartMask() : false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "serverId " + serverId + " should be non negative and cannot be greater than " + this.bitsConfig.getServerPartMask();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long l2 = this.clock.millis();
        bl2 = false;
        bl3 = false;
        long currentTime = l2;
        boolean bl5 = false;
        if (Long.highestOneBit(currentTime - this.startOfTime) > this.bitsConfig.getTimePartMask()) {
            Companion.getLogger().warn((Function0)new Function0<Object>(this){
                final /* synthetic */ AtomicIdGenerator this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return StringsKt.trimIndent((String)("\n                        Id generator configured with " + AtomicIdGenerator.access$getBitsConfig$p(this.this$0).getTimePartBits() + " bits for timestamp part.\n                        That is not enough to hold current timestamp with configured started time\n                        " + Instant.ofEpochMilli(AtomicIdGenerator.access$getStartOfTime$p(this.this$0)) + "\n                    "));
                }
            });
        }
        boolean bl6 = 0L <= (l = this.startOfTime) ? l <= currentTime : false;
        boolean bl7 = false;
        boolean bl8 = false;
        if (!bl6) {
            boolean bl9 = false;
            String string = "startOfTime " + this.startOfTime + " should be non negative and cannot be greater than current time " + currentTime;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.id = new AtomicLong(this.buildIdForNewTimestampWithZeroCounter(this.clock.millis()));
    }

    private final long buildIdForNewTimestampWithZeroCounter(long timeValue) {
        long timestampPart = (timeValue - this.startOfTime & this.bitsConfig.getTimePartMask()) << this.bitsConfig.getServerPartBits() + this.bitsConfig.getCounterPartBits();
        return timestampPart | this.serverIdPart;
    }

    private final long timeFromId(long idValue) {
        return this.startOfTime + (idValue >> this.bitsConfig.getServerPartBits() + this.bitsConfig.getCounterPartBits()) & this.bitsConfig.getTimePartMask();
    }

    @Override
    public long nextId() {
        long currentTime;
        long newIdValue;
        long idValue;
        do {
            long idTime;
            if ((idTime = this.timeFromId(idValue = this.id.get())) < (currentTime = this.clock.millis() & this.bitsConfig.getTimePartMask())) continue;
            return this.id.addAndGet(this.bitsConfig.getServerPartMask() + 1L);
        } while (!this.id.weakCompareAndSetVolatile(idValue, newIdValue = this.buildIdForNewTimestampWithZeroCounter(currentTime)));
        return newIdValue;
    }

    public final long extractTimePart(long id) {
        int shiftBits = this.bitsConfig.getServerPartBits() + this.bitsConfig.getCounterPartBits();
        return this.startOfTime + this.extractPart(id, shiftBits, this.bitsConfig.getTimePartMask());
    }

    public final long extractServerIdPart(long id) {
        return this.extractPart(id, 0, this.bitsConfig.getServerPartMask());
    }

    public final long extractCounterPart(long id) {
        return this.extractPart(id, this.bitsConfig.getServerPartBits(), this.bitsConfig.getCounterPartMask());
    }

    private final long extractPart(long id, int shiftBits, long mask) {
        return id >> shiftBits & mask;
    }

    public static final /* synthetic */ BitsConfiguration access$getBitsConfig$p(AtomicIdGenerator $this) {
        return $this.bitsConfig;
    }

    public static final /* synthetic */ long access$getStartOfTime$p(AtomicIdGenerator $this) {
        return $this.startOfTime;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lru/fix/stdlib/id/generator/AtomicIdGenerator$Companion;", "Lorg/apache/logging/log4j/kotlin/Logging;", "()V", "jfix-stdlib-id-generator"})
    public static final class Companion
    implements Logging {
        private Companion() {
        }

        @NotNull
        public KotlinLogger getLogger() {
            return Logging.DefaultImpls.getLogger((Logging)this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

