/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.common.sign.api;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum SignAlgorithmType {
    RSA,
    ECGOST3410,
    ECGOST3410_2012_256,
    ECGOST3410_2012_512;

    private static final Map<String, String> bcNames;
    private static final Map<String, String> digestUris;
    private static final Map<String, String> digestUrns;
    private static final Map<String, String> signUris;
    private static final Map<String, String> signUrns;
    private static final Map<String, List<String>> parameterSpecNames;
    private static final Map<String, String> signatureAlgorithmNames;
    private static final Map<String, List<String>> gostHashAlgorithmOid;
    private static final Map<String, String> hashAlgorithmOids;
    private static final Map<String, String> encryptionAlgorithmOids;
    private static final String ECGOST3410_2012 = "ECGOST3410-2012";

    public static SignAlgorithmType valueOf(PublicKey publicKey) {
        String algorithm = publicKey.getAlgorithm();
        if (RSA.name().equals(algorithm)) {
            return RSA;
        }
        if (ECGOST3410.name().equals(algorithm)) {
            return ECGOST3410;
        }
        if (ECGOST3410_2012.equals(algorithm) && publicKey instanceof ECPublicKey) {
            if (((ECPublicKey)publicKey).getParams().getOrder().bitLength() <= 256) {
                return ECGOST3410_2012_256;
            }
            return ECGOST3410_2012_512;
        }
        throw new IllegalArgumentException("Unsupported public key algorithm: " + algorithm);
    }

    public static SignAlgorithmType findByOid(String oid) {
        SignAlgorithmType algorithm = null;
        for (SignAlgorithmType algorithmType : SignAlgorithmType.values()) {
            if (algorithmType.name().equals("RSA") || !gostHashAlgorithmOid.get(algorithmType.name()).contains(oid)) continue;
            algorithm = algorithmType;
            break;
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Unsupported public key algorithm: " + oid);
        }
        return algorithm;
    }

    public static SignAlgorithmType findByAlgorithmName(String algorithmName) {
        SignAlgorithmType algorithm = null;
        for (SignAlgorithmType algorithmType : SignAlgorithmType.values()) {
            if (!algorithmName.endsWith(algorithmType.getBouncySignatureAlgorithmName())) continue;
            algorithm = algorithmType;
            break;
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Unsupported public key algorithm: " + algorithmName);
        }
        return algorithm;
    }

    public static SignAlgorithmType findByCertificate(X509Certificate certificate) {
        return SignAlgorithmType.findByAlgorithmName(certificate.getSigAlgName());
    }

    public String getBouncyKeyAlgorithmName() {
        return bcNames.get(this.name());
    }

    public String getBouncySignatureAlgorithmName() {
        return this.name().replaceAll("_", "-");
    }

    public String getDigestUrn() {
        return digestUrns.get(this.name());
    }

    public String getDigestUri() {
        return digestUris.get(this.name());
    }

    public String getSignUrn() {
        return signUrns.get(this.name());
    }

    public String getSignUri() {
        return signUris.get(this.name());
    }

    public String getSignatureAlgorithmName() {
        return signatureAlgorithmNames.get(this.name());
    }

    public List<String> getAvailableParameterSpecificationNames() {
        return Collections.unmodifiableList(parameterSpecNames.get(this.name()));
    }

    public String getHashAlgorithmOid() {
        return hashAlgorithmOids.get(this.name());
    }

    public String getEncryptionAlgorithmOid() {
        return encryptionAlgorithmOids.get(this.name());
    }

    static {
        bcNames = new HashMap<String, String>();
        bcNames.put(RSA.name(), RSA.name());
        bcNames.put(ECGOST3410.name(), ECGOST3410.name());
        bcNames.put(ECGOST3410_2012_256.name(), ECGOST3410_2012);
        bcNames.put(ECGOST3410_2012_512.name(), ECGOST3410_2012);
        digestUris = new HashMap<String, String>();
        digestUris.put(ECGOST3410.name(), "http://www.w3.org/2001/04/xmldsig-more#gostr3411");
        digestUris.put(ECGOST3410_2012_256.name(), "http://www.w3.org/2001/04/xmldsig-more#gostr34112012-256");
        digestUris.put(ECGOST3410_2012_512.name(), "http://www.w3.org/2001/04/xmldsig-more#gostr34112012-512");
        digestUrns = new HashMap<String, String>();
        digestUrns.put(ECGOST3410.name(), "urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr3411");
        digestUrns.put(ECGOST3410_2012_256.name(), "urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34112012-256");
        digestUrns.put(ECGOST3410_2012_512.name(), "urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34112012-512");
        signUris = new HashMap<String, String>();
        signUris.put(ECGOST3410.name(), "http://www.w3.org/2001/04/xmldsig-more#gostr34102001-gostr3411");
        signUris.put(ECGOST3410_2012_256.name(), "http://www.w3.org/2001/04/xmldsig-more#gostr34102012-gostr34112012-256");
        signUris.put(ECGOST3410_2012_512.name(), "http://www.w3.org/2001/04/xmldsig-more#gostr34102012-gostr34112012-512");
        signUrns = new HashMap<String, String>();
        signUrns.put(ECGOST3410.name(), "urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34102001-gostr3411");
        signUrns.put(ECGOST3410_2012_256.name(), "urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34102012-gostr34112012-256");
        signUrns.put(ECGOST3410_2012_512.name(), "urn:ietf:params:xml:ns:cpxmlsec:algorithms:gostr34102012-gostr34112012-512");
        parameterSpecNames = new HashMap<String, List<String>>();
        parameterSpecNames.put(RSA.name(), Collections.emptyList());
        parameterSpecNames.put(ECGOST3410.name(), Arrays.asList("GostR3410-2001-CryptoPro-A", "GostR3410-2001-CryptoPro-B", "GostR3410-2001-CryptoPro-C", "GostR3410-2001-CryptoPro-XchA", "GostR3410-2001-CryptoPro-XchB"));
        parameterSpecNames.put(ECGOST3410_2012_256.name(), Collections.singletonList("Tc26-Gost-3410-12-256-paramSetA"));
        parameterSpecNames.put(ECGOST3410_2012_512.name(), Arrays.asList("Tc26-Gost-3410-12-512-paramSetA", "Tc26-Gost-3410-12-512-paramSetB", "Tc26-Gost-3410-12-512-paramSetC"));
        signatureAlgorithmNames = new HashMap<String, String>();
        signatureAlgorithmNames.put(RSA.name(), "SHA1WITHRSA");
        signatureAlgorithmNames.put(ECGOST3410.name(), "GOST3411WITHECGOST3410");
        signatureAlgorithmNames.put(ECGOST3410_2012_256.name(), "GOST3411-2012-256WITHECGOST3410-2012-256");
        signatureAlgorithmNames.put(ECGOST3410_2012_512.name(), "GOST3411-2012-512WITHECGOST3410-2012-512");
        gostHashAlgorithmOid = new HashMap<String, List<String>>();
        gostHashAlgorithmOid.put(ECGOST3410.name(), Arrays.asList("1.2.643.2.2.9", "1.2.643.2.2.3", "1.2.643.2.2.19", "1.2.643.2.2.98"));
        gostHashAlgorithmOid.put(ECGOST3410_2012_256.name(), Arrays.asList("1.2.643.7.1.1.3.2", "1.2.643.7.1.1.2.2", "1.2.643.7.1.1.1.1", "1.2.643.7.1.1.6.1"));
        gostHashAlgorithmOid.put(ECGOST3410_2012_512.name(), Arrays.asList("1.2.643.7.1.1.2.3", "1.2.643.7.1.1.3.3", "1.2.643.7.1.1.1.2", "1.2.643.7.1.1.6.2"));
        hashAlgorithmOids = new HashMap<String, String>();
        hashAlgorithmOids.put(ECGOST3410.name(), "1.2.643.2.2.9");
        hashAlgorithmOids.put(ECGOST3410_2012_256.name(), "1.2.643.7.1.1.2.2");
        hashAlgorithmOids.put(ECGOST3410_2012_512.name(), "1.2.643.7.1.1.2.3");
        encryptionAlgorithmOids = new HashMap<String, String>();
        encryptionAlgorithmOids.put(ECGOST3410.name(), "1.2.643.2.2.19");
        encryptionAlgorithmOids.put(ECGOST3410_2012_256.name(), "1.2.643.7.1.1.1.1");
        encryptionAlgorithmOids.put(ECGOST3410_2012_512.name(), "1.2.643.7.1.1.1.2");
    }
}

