/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.feign.jaxrs;

import com.qualys.feign.jaxrs.BeanParamTransformer;
import com.qualys.feign.jaxrs.BeanParamTransformerFactory;
import com.qualys.feign.jaxrs.EncoderContext;
import feign.InvocationHandlerFactory;
import feign.Target;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.BeanParam;

class BeanParamInvocationHandlerFactory
implements InvocationHandlerFactory {
    final InvocationHandlerFactory delegate;
    final BeanParamTransformerFactory factory = new BeanParamTransformerFactory();

    public BeanParamInvocationHandlerFactory() {
        this.delegate = new InvocationHandlerFactory.Default();
    }

    public BeanParamInvocationHandlerFactory(InvocationHandlerFactory delegate) {
        this.delegate = delegate;
    }

    public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        HashMap<Method, InvocationHandlerFactory.MethodHandler> overriddenDispatch = new HashMap<Method, InvocationHandlerFactory.MethodHandler>();
        for (Map.Entry<Method, InvocationHandlerFactory.MethodHandler> entry : dispatch.entrySet()) {
            int index = this.beanParamIndex(entry.getKey());
            if (index > -1) {
                overriddenDispatch.put(entry.getKey(), new BeanParamMethodHandler(entry.getValue(), this.factory.createTransformer(entry.getKey().getParameterTypes()[index], index), index));
                continue;
            }
            overriddenDispatch.put(entry.getKey(), entry.getValue());
        }
        return this.delegate.create(target, overriddenDispatch);
    }

    int beanParamIndex(Method method) {
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            for (Annotation annotation : annotations[i]) {
                if (!BeanParam.class.isAssignableFrom(annotation.getClass())) continue;
                return i;
            }
        }
        return -1;
    }

    public static class BeanParamMethodHandler
    implements InvocationHandlerFactory.MethodHandler {
        final InvocationHandlerFactory.MethodHandler delegate;
        final BeanParamTransformer transformer;
        final int paramIndex;

        public BeanParamMethodHandler(InvocationHandlerFactory.MethodHandler delegate, BeanParamTransformer transformer, int paramIndex) {
            this.delegate = delegate;
            this.transformer = transformer;
            this.paramIndex = paramIndex;
        }

        public Object invoke(Object[] argv) throws Throwable {
            Map<String, Object> params = this.transformer.transform(argv);
            argv[this.paramIndex] = new EncoderContext(this.paramIndex, this.transformer, params);
            return this.delegate.invoke(argv);
        }
    }
}

