/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.feign.jaxrs;

import com.google.common.collect.Multimap;
import feign.Param;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.QueryParam;

class BeanParamTransformer
implements Param.Expander {
    final String[][] names;
    final Multimap<Class<?>, String> params;
    final Field[] fields;
    final Method[] getters;
    final int index;

    public BeanParamTransformer(String[][] names, Multimap<Class<?>, String> params, Field[] fields, Method[] getters, int index) {
        this.names = names;
        this.params = params;
        this.fields = fields;
        this.getters = getters;
        this.index = index;
    }

    public Map<String, Object> transform(Object[] argv) {
        Object param = argv[this.index];
        try {
            HashMap<String, Object> mapped = new HashMap<String, Object>();
            for (int i = 0; i < this.names.length; ++i) {
                Object value = this.fields[i] != null ? this.fields[i].get(param) : this.getters[i].invoke(param, new Object[0]);
                for (String name : this.names[i]) {
                    mapped.put(name, value);
                }
            }
            return mapped;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<String> formParams() {
        return this.params.get(FormParam.class);
    }

    public Collection<String> queryParams() {
        return this.params.get(QueryParam.class);
    }

    public Collection<String> headerParams() {
        return this.params.get(HeaderParam.class);
    }

    public String expand(Object value) {
        throw new IllegalStateException("Not implemented");
    }
}

