/*
 * Decompiled with CFR 0.152.
 */
package ru.l3r8y.parser;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import ru.l3r8y.Method;
import ru.l3r8y.Methods;
import ru.l3r8y.parser.ParsedMethod;

public final class ClassMethods
implements Methods {
    private final Path path;

    @Override
    public Collection<Method> all() {
        ArrayList<Method> methods = new ArrayList<Method>(0);
        try {
            CompilationUnit parsed = StaticJavaParser.parse((Path)this.path);
            for (Node clazz : parsed.getChildNodes()) {
                if (!(clazz instanceof ClassOrInterfaceDeclaration)) continue;
                this.fromNodeToParsedMethod(methods, (ClassOrInterfaceDeclaration)clazz);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Unable to get all methods: %s", ex.getMessage()), ex);
        }
        return methods;
    }

    private void fromNodeToParsedMethod(Collection<Method> methods, ClassOrInterfaceDeclaration clazz) {
        for (MethodDeclaration method : clazz.getMethods()) {
            methods.add(new ParsedMethod(clazz.getNameAsString(), method.getNameAsString(), method.getBody().orElse(new BlockStmt()).toString(), this.path));
        }
    }

    public ClassMethods(Path path) {
        this.path = path;
    }
}

