/*
 * Decompiled with CFR 0.152.
 */
package ru.l3r8y.rule;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.l3r8y.Complaint;
import ru.l3r8y.Method;
import ru.l3r8y.Rule;
import ru.l3r8y.parser.ClassMethods;
import ru.l3r8y.rule.MethodContainsAssigment;

public final class CompositePathRule
implements Rule {
    private final Path start;

    public List<Complaint> complaints() {
        List<Complaint> accum;
        block9: {
            if (Files.exists(this.start, new LinkOption[0])) {
                try (Stream<Path> files = Files.walk(this.start, new FileVisitOption[0]);){
                    accum = files.filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".java")).map(ClassMethods::new).map(ClassMethods::all).map(CompositePathRule::checkAssigment).flatMap(Collection::stream).collect(Collectors.toList());
                    break block9;
                }
                catch (IOException ex) {
                    throw new IllegalStateException(String.format("Error occupied while checking java sources: %s\n", ex.getMessage()), ex);
                }
            }
            accum = Collections.emptyList();
        }
        return accum;
    }

    private static Collection<Complaint> checkAssigment(Collection<Method> methods) {
        List<Complaint> result;
        if (methods.isEmpty()) {
            result = Collections.emptyList();
        } else {
            ArrayList<Complaint> cmps = new ArrayList<Complaint>(0);
            methods.stream().map(MethodContainsAssigment::new).map(MethodContainsAssigment::complaints).forEach(cmps::addAll);
            result = cmps;
        }
        return result;
    }

    public CompositePathRule(Path start) {
        this.start = start;
    }
}

