/*
 * Decompiled with CFR 0.152.
 */
package ru.lanwen.verbalregex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VerbalExpression {
    private final Pattern pattern;

    private VerbalExpression(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean testExact(String pToTest) {
        boolean ret = false;
        if (pToTest != null) {
            ret = this.pattern.matcher(pToTest).matches();
        }
        return ret;
    }

    public boolean test(String pToTest) {
        boolean ret = false;
        if (pToTest != null) {
            ret = this.pattern.matcher(pToTest).find();
        }
        return ret;
    }

    public String getText(String toTest) {
        return this.getText(toTest, 0);
    }

    public String getText(String toTest, int group) {
        Matcher m = this.pattern.matcher(toTest);
        StringBuilder result = new StringBuilder();
        while (m.find()) {
            result.append(m.group(group));
        }
        return result.toString();
    }

    public String toString() {
        return this.pattern.pattern();
    }

    public static Builder regex(Builder pBuilder) {
        Builder builder = new Builder();
        builder.prefixes = new StringBuilder(pBuilder.prefixes);
        builder.source = new StringBuilder(pBuilder.source);
        builder.suffixes = new StringBuilder(pBuilder.suffixes);
        builder.modifiers = pBuilder.modifiers;
        return builder;
    }

    public static Builder regex() {
        return new Builder();
    }

    public static class Builder {
        private StringBuilder prefixes = new StringBuilder();
        private StringBuilder source = new StringBuilder();
        private StringBuilder suffixes = new StringBuilder();
        private int modifiers = 8;

        Builder() {
        }

        private String sanitize(String pValue) {
            return pValue.replaceAll("[\\W]", "\\\\$0");
        }

        private int countOccurrencesOf(String where, String what) {
            return (where.length() - where.replace(what, "").length()) / what.length();
        }

        public VerbalExpression build() {
            Pattern pattern = Pattern.compile(new StringBuilder(this.prefixes).append((CharSequence)this.source).append((CharSequence)this.suffixes).toString(), this.modifiers);
            return new VerbalExpression(pattern);
        }

        public Builder add(String pValue) {
            this.source.append(pValue);
            return this;
        }

        public Builder add(Builder regex) {
            return this.group().add(regex.build().toString()).endGr();
        }

        public Builder startOfLine(boolean pEnable) {
            this.prefixes.append(pEnable ? "^" : "");
            if (!pEnable) {
                this.prefixes = new StringBuilder(this.prefixes.toString().replace("^", ""));
            }
            return this;
        }

        public Builder startOfLine() {
            return this.startOfLine(true);
        }

        public Builder endOfLine(boolean pEnable) {
            this.suffixes.append(pEnable ? "$" : "");
            if (!pEnable) {
                this.suffixes = new StringBuilder(this.suffixes.toString().replace("$", ""));
            }
            return this;
        }

        public Builder endOfLine() {
            return this.endOfLine(true);
        }

        public Builder then(String pValue) {
            return this.add("(?:" + this.sanitize(pValue) + ")");
        }

        public Builder find(String value) {
            return this.then(value);
        }

        public Builder maybe(String pValue) {
            return this.then(pValue).add("?");
        }

        public Builder anything() {
            return this.add("(?:.*)");
        }

        public Builder anythingButNot(String pValue) {
            return this.add("(?:[^" + this.sanitize(pValue) + "]*)");
        }

        public Builder something() {
            return this.add("(?:.+)");
        }

        public Builder somethingButNot(String pValue) {
            return this.add("(?:[^" + this.sanitize(pValue) + "]+)");
        }

        public Builder lineBreak() {
            return this.add("(?:\\n|(\\r\\n))");
        }

        public Builder br() {
            return this.lineBreak();
        }

        public Builder tab() {
            return this.add("(?:\\t)");
        }

        public Builder word() {
            return this.add("(?:\\w+)");
        }

        public Builder wordChar() {
            return this.add("(?:\\w)");
        }

        public Builder nonWordChar() {
            return this.add("(?:\\W)");
        }

        public Builder nonDigit() {
            return this.add("(?:\\D)");
        }

        public Builder digit() {
            return this.add("(?:\\d)");
        }

        public Builder space() {
            return this.add("(?:\\s)");
        }

        public Builder nonSpace() {
            return this.add("(?:\\S)");
        }

        public Builder anyOf(String pValue) {
            this.add("[" + this.sanitize(pValue) + "]");
            return this;
        }

        public Builder any(String value) {
            return this.anyOf(value);
        }

        public Builder range(String ... pArgs) {
            StringBuilder value = new StringBuilder("[");
            for (int firstInPairPosition = 1; firstInPairPosition < pArgs.length; firstInPairPosition += 2) {
                String from = this.sanitize(pArgs[firstInPairPosition - 1]);
                String to = this.sanitize(pArgs[firstInPairPosition]);
                value.append(from).append("-").append(to);
            }
            value.append("]");
            return this.add(value.toString());
        }

        public Builder addModifier(char pModifier) {
            switch (pModifier) {
                case 'd': {
                    this.modifiers |= 1;
                    break;
                }
                case 'i': {
                    this.modifiers |= 2;
                    break;
                }
                case 'x': {
                    this.modifiers |= 4;
                    break;
                }
                case 'm': {
                    this.modifiers |= 8;
                    break;
                }
                case 's': {
                    this.modifiers |= 0x20;
                    break;
                }
                case 'u': {
                    this.modifiers |= 0x40;
                    break;
                }
                case 'U': {
                    this.modifiers |= 0x100;
                    break;
                }
            }
            return this;
        }

        public Builder removeModifier(char pModifier) {
            switch (pModifier) {
                case 'd': {
                    this.modifiers ^= 1;
                    break;
                }
                case 'i': {
                    this.modifiers ^= 2;
                    break;
                }
                case 'x': {
                    this.modifiers ^= 4;
                    break;
                }
                case 'm': {
                    this.modifiers ^= 8;
                    break;
                }
                case 's': {
                    this.modifiers ^= 0x20;
                    break;
                }
                case 'u': {
                    this.modifiers ^= 0x40;
                    break;
                }
                case 'U': {
                    this.modifiers ^= 0x100;
                    break;
                }
            }
            return this;
        }

        public Builder withAnyCase(boolean pEnable) {
            if (pEnable) {
                this.addModifier('i');
            } else {
                this.removeModifier('i');
            }
            return this;
        }

        public Builder withAnyCase() {
            return this.withAnyCase(true);
        }

        public Builder searchOneLine(boolean pEnable) {
            if (pEnable) {
                this.removeModifier('m');
            } else {
                this.addModifier('m');
            }
            return this;
        }

        public Builder multiple(String pValue, int ... count) {
            if (count == null) {
                return this.then(pValue).oneOrMore();
            }
            switch (count.length) {
                case 1: {
                    return this.then(pValue).count(count[0]);
                }
                case 2: {
                    return this.then(pValue).count(count[0], count[1]);
                }
            }
            return this.then(pValue).oneOrMore();
        }

        public Builder oneOrMore() {
            return this.add("+");
        }

        public Builder zeroOrMore() {
            return this.add("*");
        }

        public Builder count(int count) {
            this.source.append("{").append(count).append("}");
            return this;
        }

        public Builder count(int from, int to) {
            this.source.append("{").append(from).append(",").append(to).append("}");
            return this;
        }

        public Builder atLeast(int from) {
            return this.add("{").add(String.valueOf(from)).add(",}");
        }

        public Builder or(String pValue) {
            this.prefixes.append("(");
            int opened = this.countOccurrencesOf(this.prefixes.toString(), "(");
            int closed = this.countOccurrencesOf(this.suffixes.toString(), ")");
            if (opened >= closed) {
                this.suffixes = new StringBuilder(")" + this.suffixes.toString());
            }
            this.add(")|(?:");
            if (pValue != null) {
                this.then(pValue);
            }
            return this;
        }

        public Builder capture() {
            this.suffixes.append(")");
            return this.add("(");
        }

        public Builder capt() {
            return this.capture();
        }

        public Builder group() {
            this.suffixes.append(")");
            return this.add("(?:");
        }

        public Builder endCapture() {
            if (this.suffixes.indexOf(")") != -1) {
                this.suffixes.setLength(this.suffixes.length() - 1);
                return this.add(")");
            }
            throw new IllegalStateException("Can't end capture (group) when it not started");
        }

        public Builder endCapt() {
            return this.endCapture();
        }

        public Builder endGr() {
            return this.endCapture();
        }
    }
}

