/*
 * Decompiled with CFR 0.152.
 */
package ru.lanwen.wiremock.ext;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.core.Options;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.lanwen.wiremock.config.WiremockConfigFactory;
import ru.lanwen.wiremock.config.WiremockCustomizer;
import ru.lanwen.wiremock.ext.Validate;

public class WiremockResolver
implements ParameterResolver,
AfterEachCallback {
    private static final Logger log = LoggerFactory.getLogger(WiremockResolver.class);
    static final String WIREMOCK_PORT = "wiremock.port";
    private WireMockServer server;

    public void afterEach(TestExtensionContext testExtensionContext) throws Exception {
        if (this.server == null || !this.server.isRunning()) {
            return;
        }
        this.server.resetRequests();
        this.server.resetToDefaultMappings();
        log.info("Stopping wiremock server on localhost:{}", (Object)this.server.port());
        this.server.stop();
    }

    public boolean supports(ParameterContext parameterContext, ExtensionContext context) {
        return parameterContext.getParameter().isAnnotationPresent(Wiremock.class);
    }

    public Object resolve(ParameterContext parameterContext, ExtensionContext context) {
        Validate.validState(Optional.ofNullable(this.server).map(WireMockServer::isRunning).orElse(false) == false, "Can't inject more than one server");
        Wiremock mockedServer = parameterContext.getParameter().getAnnotation(Wiremock.class);
        try {
            this.server = new WireMockServer((Options)mockedServer.factory().newInstance().create());
        }
        catch (ReflectiveOperationException e) {
            throw new ParameterResolutionException(String.format("Can't create config with given factory %s", mockedServer.factory()), (Throwable)e);
        }
        this.server.start();
        try {
            mockedServer.customizer().newInstance().customize(this.server);
        }
        catch (ReflectiveOperationException e) {
            throw new ParameterResolutionException(String.format("Can't customize server with given customizer %s", mockedServer.customizer()), (Throwable)e);
        }
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{WiremockResolver.class}));
        store.put((Object)WIREMOCK_PORT, (Object)this.server.port());
        log.info("Started wiremock server on localhost:{}", (Object)this.server.port());
        return this.server;
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Wiremock {
        public Class<? extends WiremockConfigFactory> factory() default WiremockConfigFactory.DefaultWiremockConfigFactory.class;

        public Class<? extends WiremockCustomizer> customizer() default WiremockCustomizer.NoopWiremockCustomizer.class;
    }
}

