/*
 * Decompiled with CFR 0.152.
 */
package ru.lanwen.wiremock.ext;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.core.Options;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import ru.lanwen.wiremock.config.CustomizationContext;
import ru.lanwen.wiremock.config.WiremockCustomizer;
import ru.lanwen.wiremock.ext.WiremockResolver;

class WiremockFactory {
    WiremockFactory() {
    }

    public WireMockServer createServer(WiremockResolver.Wiremock mockedServer) {
        try {
            return new WireMockServer((Options)mockedServer.factory().newInstance().create());
        }
        catch (ReflectiveOperationException e) {
            throw new ParameterResolutionException(String.format("Can't create config with given factory %s", mockedServer.factory()), (Throwable)e);
        }
    }

    public CustomizationContext.CustomizationContextBuilder createContextBuilder() {
        return CustomizationContext.builder();
    }

    public WiremockCustomizer createCustomizer(WiremockResolver.Wiremock mockedServer) {
        try {
            return mockedServer.customizer().newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new ParameterResolutionException(String.format("Can't customize server with given customizer %s", mockedServer.customizer()), (Throwable)e);
        }
    }
}

