/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import one.nio.util.Utf8;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cpus {
    private static final Log log = LogFactory.getLog(Cpus.class);
    public static final int ONLINE = Cpus.cpus("/sys/devices/system/cpu/online");
    public static final int POSSIBLE = Cpus.cpus("/sys/devices/system/cpu/possible");
    public static final int PRESENT = Cpus.cpus("/sys/devices/system/cpu/present");

    private static int cpus(String rangeFile) {
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(rangeFile, new String[0]));
            String rangeStr = Utf8.read(bytes, 0, bytes.length).trim();
            int cpus = 0;
            for (String range : rangeStr.split(",")) {
                String[] s = range.split("-");
                if (s.length == 1) {
                    ++cpus;
                    continue;
                }
                cpus += 1 + Integer.parseInt(s[1]) - Integer.parseInt(s[0]);
            }
            return cpus;
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to read " + rangeFile), (Throwable)e);
            }
            return Runtime.getRuntime().availableProcessors();
        }
    }
}

