/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import one.nio.os.NativeLibrary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class User {
    private static final Log log = LogFactory.getLog(NativeLibrary.class);
    public static final boolean IS_SUPPORTED = NativeLibrary.IS_SUPPORTED;
    public static final String PASSWD = "/etc/passwd";
    public static final String GROUP = "/etc/group";
    public static final int U_NAME = 0;
    public static final int U_PASSWORD = 1;
    public static final int U_UID = 2;
    public static final int U_GID = 3;
    public static final int U_GECOS = 4;
    public static final int U_DIRECTORY = 5;
    public static final int U_SHELL = 6;
    public static final int G_NAME = 0;
    public static final int G_PASSWORD = 1;
    public static final int G_GID = 2;
    public static final int G_USER_LIST = 3;

    public static native int setuid(int var0);

    public static native int setgid(int var0);

    public static native int setgroups(int[] var0);

    public static native int chown(String var0, int var1, int var2);

    public static String[] findUser(String user) {
        return User.find(PASSWD, user);
    }

    public static int findUid(String user) {
        String[] userInfo = User.findUser(user);
        return userInfo != null ? Integer.parseInt(userInfo[2]) : -1;
    }

    public static String[] findGroup(String group) {
        return User.find(GROUP, group);
    }

    public static int findGid(String group) {
        String[] groupInfo = User.findGroup(group);
        return groupInfo != null ? Integer.parseInt(groupInfo[2]) : -1;
    }

    public static List<String[]> findSupplementaryGroups(String user) {
        ArrayList<String[]> groupInfos = new ArrayList<String[]>();
        Pattern userPattern = Pattern.compile("\\b\\Q" + user + "\\E\\b");
        try (BufferedReader reader = new BufferedReader(new FileReader(GROUP));){
            String s;
            while ((s = reader.readLine()) != null) {
                String[] groupInfo = s.split(":");
                if (groupInfo.length <= 3 || !userPattern.matcher(groupInfo[3]).find()) continue;
                groupInfos.add(groupInfo);
            }
        }
        catch (IOException e) {
            log.warn((Object)"Cannot read /etc/group", (Throwable)e);
        }
        return groupInfos;
    }

    public static int[] findSupplementaryGids(String user) {
        List<String[]> groupInfos = User.findSupplementaryGroups(user);
        int[] gids = new int[groupInfos.size()];
        for (int i = 0; i < gids.length; ++i) {
            gids[i] = Integer.parseInt(groupInfos.get(i)[2]);
        }
        return gids;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] find(String file, String account) {
        String searchString = account + ':';
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String s;
            do {
                if ((s = reader.readLine()) == null) return null;
            } while (!s.startsWith(searchString));
            String[] stringArray = s.split(":");
            return stringArray;
        }
        catch (IOException e) {
            log.warn((Object)("Cannot read " + file), (Throwable)e);
        }
        return null;
    }
}

