/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.bpf;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import one.nio.os.Cpus;
import one.nio.os.bpf.Bpf;
import one.nio.os.bpf.BpfObj;
import one.nio.os.bpf.MapType;

public class BpfMap
extends BpfObj
implements Closeable {
    public static final int CPUS = Cpus.POSSIBLE;
    public static final int ARRAY_KEY_SIZE = 4;
    public final MapType type;
    public final int keySize;
    public final int valueSize;
    public final int totalValueSize;
    public final int maxEntries;
    public final int flags;

    BpfMap(MapType type, int id, String name, int keySize, int valueSize, int maxEntries, int flags, int fd) {
        super(id, name, fd);
        this.keySize = keySize;
        this.valueSize = valueSize;
        this.maxEntries = maxEntries;
        this.flags = flags;
        this.totalValueSize = type.perCpu ? BpfMap.roundUp(valueSize) * CPUS : valueSize;
        this.type = type;
    }

    private static int roundUp(int valueSize) {
        return valueSize + 7 & 0xFFFFFFF8;
    }

    public boolean get(byte[] key, byte[] result) throws IOException {
        return this.get(key, result, 0);
    }

    protected boolean get(byte[] key, byte[] result, int flags) throws IOException {
        this.checkKeyLength(key.length);
        this.checkTotalValueLength(result.length);
        return Bpf.mapLookup(this.fd(), key, result, flags);
    }

    public byte[] get(byte[] key) throws IOException {
        this.checkKeyLength(key.length);
        byte[] result = new byte[this.totalValueSize];
        boolean res = this.get(key, result);
        return (byte[])(res ? result : null);
    }

    public boolean put(byte[] key, byte[] value) throws IOException {
        return this.put(key, value, 0);
    }

    public boolean putIfAbsent(byte[] key, byte[] value) throws IOException {
        return this.put(key, value, 1);
    }

    public boolean putIfPresent(byte[] key, byte[] value) throws IOException {
        return this.put(key, value, 2);
    }

    protected boolean put(byte[] key, byte[] value, int flags) throws IOException {
        this.checkKeyLength(key.length);
        this.checkTotalValueLength(value.length);
        return Bpf.mapUpdate(this.fd(), key, value, flags);
    }

    public boolean remove(byte[] key) throws IOException {
        this.checkKeyLength(key.length);
        return Bpf.mapRemove(this.fd(), key);
    }

    public Iterable<byte[]> keys() {
        return () -> new KeysIterator();
    }

    public BpfMap synchronizedMap() {
        return new SynchronizedBpfMap(this);
    }

    public static BpfMap getPinned(String path) throws IOException {
        int fd = Bpf.objectGet(path);
        return BpfMap.getByFd(fd);
    }

    public static BpfMap getById(int id) throws IOException {
        int fd = Bpf.mapGetFdById(id);
        return BpfMap.getByFd(fd);
    }

    public static BpfMap getByFd(int fd) throws IOException {
        int[] res = new int[6];
        String name = Bpf.mapGetInfo(fd, res);
        MapType type = MapType.values()[res[0]];
        int id = res[1];
        int keySize = res[2];
        int valueSize = res[3];
        int maxEntries = res[4];
        int flags = res[5];
        return new BpfMap(type, id, name, keySize, valueSize, maxEntries, flags, fd);
    }

    public static BpfMap newMap(MapType type, int keySize, int valueSize, int maxEntries, String name, int flags) throws IOException {
        int fd = Bpf.mapCreate(type.ordinal(), keySize, valueSize, maxEntries, name, flags, 0);
        return BpfMap.getByFd(fd);
    }

    public static BpfMap newMapOfMaps(MapType type, int keySize, int maxEntries, String name, int flags, BpfMap innerMap) throws IOException {
        int fd = Bpf.mapCreate(type.ordinal(), keySize, 4, maxEntries, name, flags, innerMap.fd());
        return BpfMap.getByFd(fd);
    }

    public static BpfMap newPerfEventArray(String name, int flags) throws IOException {
        return BpfMap.newMap(MapType.PERF_EVENT_ARRAY, 4, 4, CPUS, name, flags);
    }

    private void checkKeyLength(int length) {
        if (this.keySize != length) {
            throw new IllegalArgumentException("Invalid key size");
        }
    }

    private void checkTotalValueLength(int length) {
        if (this.totalValueSize != length) {
            throw new IllegalArgumentException("Invalid value size");
        }
    }

    public static Iterable<Integer> getAllIds() {
        return () -> new BpfObj.IdsIterator(1);
    }

    public static byte[] bytes(int i) {
        return ByteBuffer.allocate(4).order(ByteOrder.nativeOrder()).putInt(i).array();
    }

    public static byte[] bytes(long i) {
        return ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(i).array();
    }

    public static ByteBuffer bytes(byte[] value) {
        return ByteBuffer.wrap(value).order(ByteOrder.nativeOrder());
    }

    public static IntBuffer ints(byte[] value) {
        return ByteBuffer.wrap(value).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public static LongBuffer longs(byte[] value) {
        return ByteBuffer.wrap(value).order(ByteOrder.nativeOrder()).asLongBuffer();
    }

    private static class SynchronizedBpfMap
    extends BpfMap {
        public SynchronizedBpfMap(BpfMap map) {
            super(map.type, map.id, map.name, map.keySize, map.valueSize, map.maxEntries, map.flags, map.fd());
        }

        @Override
        protected boolean get(byte[] key, byte[] result, int flags) throws IOException {
            return super.get(key, result, flags | 4);
        }

        @Override
        protected boolean put(byte[] key, byte[] value, int flags) throws IOException {
            return super.put(key, value, flags | 4);
        }
    }

    class KeysIterator
    implements Iterator<byte[]> {
        byte[] next;
        boolean nextChecked;

        KeysIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this.nextChecked) {
                byte[] buf = new byte[BpfMap.this.keySize];
                boolean hasNext = Bpf.mapGetNextKey(BpfMap.this.fd(), this.next, buf);
                this.next = (byte[])(hasNext ? buf : null);
                this.nextChecked = true;
            }
            return this.next != null;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextChecked = false;
            return this.next;
        }
    }
}

