/*
 * Decompiled with CFR 0.152.
 */
package one.nio.rpc;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import one.nio.net.ConnectionString;
import one.nio.net.Socket;
import one.nio.pool.SocketPool;
import one.nio.rpc.RemoteCall;
import one.nio.rpc.RpcPacket;
import one.nio.rpc.stream.RpcStreamImpl;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.DeserializeStream;
import one.nio.serial.Repository;
import one.nio.serial.SerializeStream;
import one.nio.serial.Serializer;
import one.nio.serial.SerializerNotFoundException;

public class RpcClient
extends SocketPool
implements InvocationHandler {
    protected static final byte[][] uidLocks = new byte[64][0];

    public RpcClient(ConnectionString conn) {
        super(conn);
    }

    public Object invoke(Object request) throws Exception {
        return this.invoke(request, this.readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object request, int timeout) throws Exception {
        Object response;
        Object rawResponse = this.invokeRaw(request, timeout);
        while (true) {
            if (!(rawResponse instanceof byte[])) {
                return rawResponse;
            }
            try {
                response = new DeserializeStream((byte[])rawResponse).readObject();
            }
            catch (SerializerNotFoundException e) {
                long uid = e.getUid();
                Object object = RpcClient.uidLockFor(uid);
                synchronized (object) {
                    if (!Repository.hasSerializer(uid)) {
                        Repository.provideSerializer(this.requestSerializer(uid));
                    }
                    continue;
                }
            }
            if (!(response instanceof Exception)) {
                return response;
            }
            if (!(response instanceof SerializerNotFoundException)) break;
            long uid = ((SerializerNotFoundException)response).getUid();
            this.provideSerializer(Repository.requestSerializer(uid));
            rawResponse = this.invokeRaw(request, this.readTimeout);
        }
        throw (Exception)response;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object ... args) throws Exception {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        return this.invoke(new RemoteCall(method, args));
    }

    protected static Object uidLockFor(long uid) {
        return uidLocks[(int)uid & uidLocks.length - 1];
    }

    protected void provideSerializer(Serializer serializer) throws Exception {
        this.invokeServiceRequest(new RemoteCall(Repository.provide, serializer));
    }

    protected Serializer requestSerializer(long uid) throws Exception {
        return (Serializer)this.invokeServiceRequest(new RemoteCall(Repository.request, uid));
    }

    protected Object invokeServiceRequest(Object request) throws Exception {
        byte[] rawResponse = (byte[])this.invokeRaw(request, this.readTimeout);
        Object response = new DeserializeStream(rawResponse).readObject();
        if (response instanceof Exception) {
            throw (Exception)response;
        }
        return response;
    }

    private Object invokeRaw(Object request, int timeout) throws Exception {
        byte[] buffer = this.serialize(request);
        Socket socket = (Socket)this.borrowObject();
        try {
            try {
                this.sendRequest(socket, buffer, timeout);
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (IOException e) {
                this.destroyObject(socket);
                socket = this.createObject();
                this.sendRequest(socket, buffer, timeout);
            }
            int responseSize = RpcPacket.getSize(buffer);
            if (responseSize == -307308029) {
                return new RpcStreamImpl(socket){
                    {
                        this.socket.setTos(8);
                    }

                    @Override
                    public void close() {
                        super.close();
                        if (this.error) {
                            RpcClient.this.invalidateObject(this.socket);
                        } else {
                            this.socket.setTos(0);
                            RpcClient.this.returnObject(this.socket);
                        }
                    }
                };
            }
            RpcPacket.checkReadSize(responseSize, socket);
            if (responseSize > 4) {
                buffer = new byte[responseSize];
            }
            socket.readFully(buffer, 0, responseSize);
            this.returnObject(socket);
            return buffer;
        }
        catch (Throwable e) {
            this.invalidateObject(socket);
            throw e;
        }
    }

    private byte[] serialize(Object request) throws IOException {
        CalcSizeStream css = new CalcSizeStream();
        css.writeObject(request);
        int requestSize = css.count();
        RpcPacket.checkWriteSize(requestSize);
        byte[] buffer = new byte[requestSize + 4];
        DataStream ds = css.hasCycles() ? new SerializeStream(buffer, css.capacity()) : new DataStream(buffer);
        ds.writeInt(requestSize);
        ds.writeObject(request);
        return buffer;
    }

    private void sendRequest(Socket socket, byte[] buffer, int timeout) throws IOException {
        if (timeout != 0) {
            socket.setTimeout(timeout);
        }
        socket.writeFully(buffer, 0, buffer.length);
        socket.readFully(buffer, 0, 4);
    }
}

