/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.JsonReader;
import one.nio.serial.Serializer;

class DoubleSerializer
extends Serializer<Double> {
    DoubleSerializer() {
        super(Double.class);
    }

    @Override
    public void calcSize(Double obj, CalcSizeStream css) {
        css.count += 8;
    }

    @Override
    public void write(Double v, DataStream out) throws IOException {
        out.writeDouble(v);
    }

    @Override
    public Double read(DataStream in) throws IOException {
        Double result = in.readDouble();
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException {
        in.skipBytes(8);
    }

    @Override
    public void toJson(Double obj, StringBuilder builder) {
        builder.append(obj);
    }

    @Override
    public Double fromJson(JsonReader in) throws IOException {
        return in.readDouble();
    }

    @Override
    public Double fromString(String s) {
        return Double.valueOf(s);
    }
}

