/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.JsonReader;
import one.nio.serial.Serializer;

class IntegerSerializer
extends Serializer<Integer> {
    IntegerSerializer() {
        super(Integer.class);
    }

    @Override
    public void calcSize(Integer obj, CalcSizeStream css) {
        css.count += 4;
    }

    @Override
    public void write(Integer v, DataStream out) throws IOException {
        out.writeInt(v);
    }

    @Override
    public Integer read(DataStream in) throws IOException {
        Integer result = in.readInt();
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException {
        in.skipBytes(4);
    }

    @Override
    public void toJson(Integer obj, StringBuilder builder) {
        builder.append(obj);
    }

    @Override
    public Integer fromJson(JsonReader in) throws IOException {
        return in.readInt();
    }

    @Override
    public Integer fromString(String s) {
        return Integer.valueOf(s);
    }
}

