/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.sql.Timestamp;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.JsonReader;
import one.nio.serial.Serializer;

class TimestampSerializer
extends Serializer<Timestamp> {
    TimestampSerializer() {
        super(Timestamp.class);
    }

    @Override
    public void calcSize(Timestamp obj, CalcSizeStream css) {
        css.count += 12;
    }

    @Override
    public void write(Timestamp obj, DataStream out) throws IOException {
        out.writeLong(obj.getTime());
        out.writeInt(obj.getNanos());
    }

    @Override
    public Timestamp read(DataStream in) throws IOException {
        Timestamp result = new Timestamp(in.readLong());
        result.setNanos(in.readInt());
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException {
        in.skipBytes(12);
    }

    @Override
    public void toJson(Timestamp obj, StringBuilder builder) {
        builder.append(obj.getTime());
    }

    @Override
    public Timestamp fromJson(JsonReader in) throws IOException {
        return new Timestamp(in.readLong());
    }

    @Override
    public Timestamp fromString(String s) {
        return new Timestamp(Long.parseLong(s));
    }
}

