/*
 * Decompiled with CFR 0.152.
 */
package one.nio.util;

import java.util.TimeZone;

public class Dates {
    public static final TimeZone TIME_ZONE = TimeZone.getDefault();
    public static final long JAN_1_1600 = -11676096000000L;
    public static final long MS_IN_DAY = 86400000L;
    public static final int DAYS_IN_400_YEARS = 146097;
    public static final int DAYS_IN_4_YEARS = 1461;
    public static final int MONTH_AND_DAY_MASK = 511;
    public static final int FEB_29 = 93;
    private static final short[] CALENDAR = new short[1461];

    public static int encode(int year, int month, int day) {
        return year << 9 | month << 5 | day;
    }

    public static int year(int date) {
        return date >> 9;
    }

    public static int month(int date) {
        return date >>> 5 & 0xF;
    }

    public static int day(int date) {
        return date & 0x1F;
    }

    public static boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static int daysInMonth(int month, int year) {
        return month == 2 ? (Dates.isLeapYear(year) ? 29 : 28) : 30 + (5546 >>> month & 1);
    }

    public static long asLocal(long millis) {
        return millis + (long)TIME_ZONE.getOffset(millis);
    }

    public static int dayNum(long millis) {
        return (int)((millis - -11676096000000L) / 86400000L);
    }

    public static int dateOfMillis(long millis) {
        int dayNum = Dates.dayNum(millis);
        int y400 = dayNum / 146097;
        dayNum %= 146097;
        dayNum += (dayNum - 60) / 36524;
        int y4 = dayNum / 1461;
        return (y400 * 400 + y4 * 4 + 1600 << 9) + CALENDAR[dayNum % 1461];
    }

    public static int yearsBetween(long fromMillis, long toMillis) {
        int fromDate = Dates.dateOfMillis(fromMillis);
        int toDate = Dates.dateOfMillis(toMillis);
        if ((fromDate & 0x1FF) == 93 && !Dates.isLeapYear(toDate >> 9)) {
            --fromDate;
        }
        return toDate - fromDate >> 9;
    }

    public static int daysBetween(long fromMillis, long toMillis) {
        return Dates.dayNum(toMillis) - Dates.dayNum(fromMillis);
    }

    static {
        int dayNum = 0;
        for (int year = 0; year < 4; ++year) {
            for (int month = 1; month <= 12; ++month) {
                int days = Dates.daysInMonth(month, year);
                for (int day = 1; day <= days; ++day) {
                    Dates.CALENDAR[dayNum++] = (short)(year << 9 | month << 5 | day);
                }
            }
        }
    }
}

