/*
 * Decompiled with CFR 0.152.
 */
package one.nio.util;

import java.io.ObjectOutput;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import one.nio.util.Utf8;

public class DigestStream
implements ObjectOutput {
    protected MessageDigest md;
    protected byte[] buf;

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public DigestStream(String algorithm) {
        this(DigestStream.getDigest(algorithm), 64);
    }

    public DigestStream(MessageDigest md, int bufferSize) {
        this.md = md;
        this.buf = new byte[bufferSize];
    }

    public byte[] digest() {
        return this.md.digest();
    }

    public long digest64() {
        byte[] tmp = this.digest();
        return ((long)tmp[0] & 0x7FL) << 56 | ((long)tmp[1] & 0xFFL) << 48 | ((long)tmp[2] & 0xFFL) << 40 | ((long)tmp[3] & 0xFFL) << 32 | ((long)tmp[4] & 0xFFL) << 24 | ((long)tmp[5] & 0xFFL) << 16 | ((long)tmp[6] & 0xFFL) << 8 | (long)tmp[7] & 0xFFL;
    }

    @Override
    public void write(int b) {
        this.md.update((byte)b);
    }

    @Override
    public void write(byte[] b) {
        this.md.update(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.md.update(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.md.update(v ? (byte)1 : 0);
    }

    @Override
    public void writeByte(int v) {
        this.md.update((byte)v);
    }

    @Override
    public void writeShort(int v) {
        this.buf[0] = (byte)(v >>> 8);
        this.buf[1] = (byte)v;
        this.md.update(this.buf, 0, 2);
    }

    @Override
    public void writeChar(int v) {
        this.buf[0] = (byte)(v >>> 8);
        this.buf[1] = (byte)v;
        this.md.update(this.buf, 0, 2);
    }

    @Override
    public void writeInt(int v) {
        this.buf[0] = (byte)(v >>> 24);
        this.buf[1] = (byte)(v >>> 16);
        this.buf[2] = (byte)(v >>> 8);
        this.buf[3] = (byte)v;
        this.md.update(this.buf, 0, 4);
    }

    @Override
    public void writeLong(long v) {
        this.buf[0] = (byte)(v >>> 56);
        this.buf[1] = (byte)(v >>> 48);
        this.buf[2] = (byte)(v >>> 40);
        this.buf[3] = (byte)(v >>> 32);
        this.buf[4] = (byte)(v >>> 24);
        this.buf[5] = (byte)(v >>> 16);
        this.buf[6] = (byte)(v >>> 8);
        this.buf[7] = (byte)v;
        this.md.update(this.buf, 0, 8);
    }

    @Override
    public void writeFloat(float v) {
        this.writeInt(Float.floatToRawIntBits(v));
    }

    @Override
    public void writeDouble(double v) {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    @Override
    public void writeBytes(String s) {
        int length = s.length();
        byte[] buf = this.buf;
        int bufLength = buf.length;
        int i = 0;
        while (length > 0) {
            int lengthToCopy = Math.min(bufLength, length);
            s.getBytes(i, i + lengthToCopy, buf, 0);
            this.md.update(buf, 0, lengthToCopy);
            length -= lengthToCopy;
            i += lengthToCopy;
        }
    }

    @Override
    public void writeChars(String s) {
        int charPos = 0;
        int length = s.length();
        byte[] buf = this.buf;
        int bufLength = buf.length & 0xFFFFFFFE;
        while (charPos < length) {
            int bytesToCopy = Math.min(bufLength, (length - charPos) * 2);
            for (int pos = 0; pos < bytesToCopy; pos += 2) {
                char v = s.charAt(charPos++);
                buf[pos] = (byte)(v >>> 8);
                buf[pos + 1] = (byte)v;
            }
            this.md.update(buf, 0, bytesToCopy);
        }
    }

    @Override
    public void writeUTF(String s) {
        byte[] buf = this.buf;
        int utfLength = Utf8.length(s);
        buf[0] = (byte)(utfLength >>> 8);
        buf[1] = (byte)utfLength;
        this.md.update(buf, 0, 2);
        int bufLength = buf.length;
        int step = bufLength / 3;
        for (int pos = 0; pos < s.length(); pos += step) {
            int written = Utf8.write(s, pos, step, buf, 0);
            this.md.update(buf, 0, written);
        }
    }

    @Override
    public void writeObject(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

