/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http;

import java.util.Arrays;
import java.util.HashMap;
import one.nio.http.RequestHandler;

public class PathMapper
extends HashMap<String, RequestHandler[]> {
    public void add(String path, int[] methods, RequestHandler handler) {
        RequestHandler[] handlersByMethod = super.computeIfAbsent(path, p -> new RequestHandler[1]);
        if (methods == null) {
            handlersByMethod[0] = handler;
        } else {
            for (int method : methods) {
                if (method <= 0 || method >= 10) {
                    throw new IllegalArgumentException("Invalid RequestMethod " + method + " for path " + path);
                }
                if (method >= handlersByMethod.length) {
                    handlersByMethod = Arrays.copyOf(handlersByMethod, method + 1);
                    super.put(path, handlersByMethod);
                }
                handlersByMethod[method] = handler;
            }
        }
    }

    public RequestHandler find(String path, int method) {
        RequestHandler[] handlersByMethod = (RequestHandler[])super.get(path);
        if (handlersByMethod == null) {
            return null;
        }
        if (method > 0 && method < handlersByMethod.length && handlersByMethod[method] != null) {
            return handlersByMethod[method];
        }
        return handlersByMethod[0];
    }
}

