/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.BitSet;
import one.nio.util.Utf8;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cpus {
    private static final Log log = LogFactory.getLog(Cpus.class);
    public static final BitSet ONLINE = Cpus.cpus("/sys/devices/system/cpu/online");
    public static final BitSet PRESENT = Cpus.cpus("/sys/devices/system/cpu/present");
    public static final BitSet POSSIBLE = Cpus.cpus("/sys/devices/system/cpu/possible");
    public static final int COUNT = POSSIBLE.cardinality();

    private static BitSet cpus(String rangeFile) {
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(rangeFile, new String[0]));
            String rangeStr = Utf8.read(bytes, 0, bytes.length).trim();
            BitSet cpus = new BitSet();
            for (String range : rangeStr.split(",")) {
                String[] s = range.split("-");
                int from = Integer.parseInt(s[0]);
                int to = s.length == 1 ? from : Integer.parseInt(s[1]);
                cpus.set(from, to);
            }
            return cpus;
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to read " + rangeFile), (Throwable)e);
            }
            BitSet cpus = new BitSet();
            cpus.set(0, Runtime.getRuntime().availableProcessors());
            return cpus;
        }
    }
}

