/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.bpf;

import java.io.IOException;
import one.nio.os.bpf.Bpf;
import one.nio.os.bpf.BpfObj;
import one.nio.os.bpf.Handle;
import one.nio.os.bpf.ProgType;
import one.nio.os.perf.PerfCounter;

public class BpfProg
extends BpfObj {
    public final ProgType type;

    BpfProg(ProgType type, int id, String name, int fd) {
        super(id, name, fd);
        this.type = type;
    }

    public static BpfProg load(String path, ProgType type) throws IOException {
        int fd = Bpf.progLoad(path, type.ordinal());
        return BpfProg.getByFd(fd);
    }

    public static BpfProg getPinned(String path) throws IOException {
        int fd = Bpf.objectGet(path);
        return BpfProg.getByFd(fd);
    }

    public static BpfProg getById(int id) throws IOException {
        int fd = Bpf.progGetFdById(id);
        return BpfProg.getByFd(fd);
    }

    public static BpfProg getByFd(int fd) throws IOException {
        int[] result = new int[2];
        String name = Bpf.progGetInfo(fd, result);
        ProgType type = ProgType.values()[result[0]];
        int id = result[1];
        return new BpfProg(type, id, name, fd);
    }

    public void attach(PerfCounter counter) throws IOException {
        if (this.type != ProgType.PERF_EVENT) {
            throw new IllegalStateException();
        }
        counter.attachBpf(this.fd());
    }

    public Handle attachRawTracepoint(String name) throws IOException {
        if (this.type != ProgType.RAW_TRACEPOINT) {
            throw new IllegalStateException();
        }
        return new Handle(Bpf.rawTracepointOpen(this.fd(), name));
    }

    public int[] getMapIds() throws IOException {
        return Bpf.progGetMapIds(this.fd());
    }

    public static Iterable<Integer> getAllIds() {
        return () -> new BpfObj.IdsIterator(0);
    }
}

