/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.util.Date;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.JsonReader;
import one.nio.serial.Serializer;

class DateSerializer
extends Serializer<Date> {
    DateSerializer() {
        super(Date.class);
    }

    @Override
    public void calcSize(Date obj, CalcSizeStream css) {
        css.count += 8;
    }

    @Override
    public void write(Date obj, DataStream out) throws IOException {
        out.writeLong(obj.getTime());
    }

    @Override
    public Date read(DataStream in) throws IOException {
        Date result = new Date(in.readLong());
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException {
        in.skipBytes(8);
    }

    @Override
    public void toJson(Date obj, StringBuilder builder) {
        builder.append(obj.getTime());
    }

    @Override
    public Date fromJson(JsonReader in) throws IOException {
        return new Date(in.readLong());
    }

    @Override
    public Date fromString(String s) {
        return new Date(Long.parseLong(s));
    }
}

