/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import one.nio.serial.JsonReader;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.util.Base64;

public class Json {
    public static void appendChar(StringBuilder builder, char c) {
        builder.append('\"');
        if (c == '\"' || c == '\\') {
            builder.append('\\');
        }
        builder.append(c).append('\"');
    }

    public static void appendChars(StringBuilder builder, char[] obj) {
        builder.append('\"');
        int from = 0;
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] != '\"' && obj[i] != '\\') continue;
            builder.append(obj, from, i - from).append('\\');
            from = i;
        }
        builder.append(obj, from, obj.length - from).append('\"');
    }

    public static void appendString(StringBuilder builder, String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c != '\"' && c != '\\') continue;
            Json.appendChars(builder, s.toCharArray());
            return;
        }
        builder.append('\"').append(s).append('\"');
    }

    public static void appendBinary(StringBuilder builder, byte[] array) {
        builder.append('\"').append(Base64.encodeToChars(array)).append('\"');
    }

    public static void appendObject(StringBuilder builder, Object obj) throws IOException {
        if (obj == null) {
            builder.append("null");
        } else {
            Serializer<?> serializer = Repository.get(obj.getClass());
            serializer.toJson(obj, builder);
        }
    }

    public static String toJson(Object obj) throws IOException {
        if (obj == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder(240);
        Serializer<?> serializer = Repository.get(obj.getClass());
        serializer.toJson(obj, builder);
        return builder.toString();
    }

    public static Object fromJson(String s) throws IOException, ClassNotFoundException {
        JsonReader reader = new JsonReader(s.getBytes(StandardCharsets.UTF_8));
        return reader.readObject();
    }

    public static <T> T fromJson(String s, Class<T> cls) throws IOException, ClassNotFoundException {
        JsonReader reader = new JsonReader(s.getBytes(StandardCharsets.UTF_8));
        return reader.readObject(cls);
    }

    public static Object fromJson(String s, Type type) throws IOException, ClassNotFoundException {
        JsonReader reader = new JsonReader(s.getBytes(StandardCharsets.UTF_8));
        return reader.readObject(type);
    }
}

