/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial.gen;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.util.Map;
import one.nio.serial.gen.NullObjectInputStream;

class GetFieldInputStream
extends NullObjectInputStream {
    private final Map<String, Field> fields;
    private final Object source;

    GetFieldInputStream(Object source, Map<String, Field> fields) throws IOException, SecurityException {
        this.fields = fields;
        this.source = source;
    }

    @Override
    public ObjectInputStream.GetField readFields() {
        return new ObjectGetField(this.fields, this.source);
    }

    private static class ObjectGetField
    extends ObjectInputStream.GetField {
        private final Object object;
        private final Map<String, Field> fields;

        private ObjectGetField(Map<String, Field> fields, Object object) {
            this.object = object;
            this.fields = fields;
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean defaulted(String name) {
            return !this.fields.containsKey(name);
        }

        @Override
        public boolean get(String name, boolean val) throws IOException {
            try {
                Field field = this.fields.get(name);
                return field != null ? field.getBoolean(this.object) : val;
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }

        @Override
        public byte get(String name, byte val) throws IOException {
            try {
                Field field = this.fields.get(name);
                return field != null ? field.getByte(this.object) : val;
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }

        @Override
        public char get(String name, char val) throws IOException {
            try {
                Field field = this.fields.get(name);
                return field != null ? field.getChar(this.object) : val;
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }

        @Override
        public short get(String name, short val) throws IOException {
            try {
                Field field = this.fields.get(name);
                return field != null ? field.getShort(this.object) : val;
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }

        @Override
        public int get(String name, int val) throws IOException {
            try {
                Field field = this.fields.get(name);
                return field != null ? field.getInt(this.object) : val;
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }

        @Override
        public long get(String name, long val) throws IOException {
            try {
                Field field = this.fields.get(name);
                return field != null ? field.getLong(this.object) : val;
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }

        @Override
        public float get(String name, float val) throws IOException {
            try {
                Field field = this.fields.get(name);
                return field != null ? field.getFloat(this.object) : val;
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }

        @Override
        public double get(String name, double val) throws IOException {
            try {
                Field field = this.fields.get(name);
                return field != null ? field.getDouble(this.object) : val;
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }

        @Override
        public Object get(String name, Object val) throws IOException {
            try {
                Field field = this.fields.get(name);
                return field != null ? field.get(this.object) : val;
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }
    }
}

