/*
 * Decompiled with CFR 0.152.
 */
package one.nio.util;

public final class Base64 {
    public static final byte[] DEFAULT_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    public static final byte[] URL_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] DECODE_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 62, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 63, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    public static byte[] encode(byte[] s) {
        byte[] result = new byte[(s.length + 2) / 3 << 2];
        Base64.encode(s, result, 0, DEFAULT_TABLE);
        return result;
    }

    public static byte[] encodeUrl(byte[] s) {
        byte[] result = new byte[((s.length << 2) + 2) / 3];
        Base64.encode(s, result, 0, URL_TABLE);
        return result;
    }

    public static void encode(byte[] s, byte[] result, int p, byte[] table) {
        int len = s.length / 3 * 3;
        int i = 0;
        while (i < len) {
            int v = (s[i] & 0xFF) << 16 | (s[i + 1] & 0xFF) << 8 | s[i + 2] & 0xFF;
            result[p] = table[v >>> 18];
            result[p + 1] = table[v >>> 12 & 0x3F];
            result[p + 2] = table[v >>> 6 & 0x3F];
            result[p + 3] = table[v & 0x3F];
            i += 3;
            p += 4;
        }
        switch (s.length - len) {
            case 1: {
                result[p] = table[(s[len] & 0xFF) >> 2];
                result[p + 1] = table[(s[len] & 3) << 4];
                if (p + 3 >= result.length) break;
                result[p + 2] = 61;
                result[p + 3] = 61;
                break;
            }
            case 2: {
                result[p] = table[(s[len] & 0xFF) >> 2];
                result[p + 1] = table[(s[len] & 3) << 4 | (s[len + 1] & 0xFF) >> 4];
                result[p + 2] = table[(s[len + 1] & 0xF) << 2];
                if (p + 3 >= result.length) break;
                result[p + 3] = 61;
            }
        }
    }

    public static char[] encodeToChars(byte[] s) {
        char[] result = new char[(s.length + 2) / 3 << 2];
        Base64.encodeToChars(s, result, 0, DEFAULT_TABLE);
        return result;
    }

    public static char[] encodeUrlToChars(byte[] s) {
        char[] result = new char[((s.length << 2) + 2) / 3];
        Base64.encodeToChars(s, result, 0, URL_TABLE);
        return result;
    }

    public static void encodeToChars(byte[] s, char[] result, int p, byte[] table) {
        int len = s.length / 3 * 3;
        int i = 0;
        while (i < len) {
            int v = (s[i] & 0xFF) << 16 | (s[i + 1] & 0xFF) << 8 | s[i + 2] & 0xFF;
            result[p] = (char)table[v >>> 18];
            result[p + 1] = (char)table[v >>> 12 & 0x3F];
            result[p + 2] = (char)table[v >>> 6 & 0x3F];
            result[p + 3] = (char)table[v & 0x3F];
            i += 3;
            p += 4;
        }
        switch (s.length - len) {
            case 1: {
                result[p] = (char)table[(s[len] & 0xFF) >> 2];
                result[p + 1] = (char)table[(s[len] & 3) << 4];
                if (p + 3 >= result.length) break;
                result[p + 2] = 61;
                result[p + 3] = 61;
                break;
            }
            case 2: {
                result[p] = (char)table[(s[len] & 0xFF) >> 2];
                result[p + 1] = (char)table[(s[len] & 3) << 4 | (s[len + 1] & 0xFF) >> 4];
                result[p + 2] = (char)table[(s[len + 1] & 0xF) << 2];
                if (p + 3 >= result.length) break;
                result[p + 3] = 61;
            }
        }
    }

    public static byte[] decode(byte[] s) {
        return Base64.decode(s, s.length);
    }

    public static byte[] decode(byte[] s, int len) {
        while (len > 0 && s[len - 1] == 61) {
            --len;
        }
        int full = (len >> 2) * 3;
        int pad = (len & 3) * 3 >> 2;
        byte[] result = new byte[full + pad];
        byte[] table = DECODE_TABLE;
        int i = 0;
        int p = 0;
        while (p < full) {
            int v = table[s[i]] << 18 | table[s[i + 1]] << 12 | table[s[i + 2]] << 6 | table[s[i + 3]];
            result[p] = (byte)(v >>> 16);
            result[p + 1] = (byte)(v >>> 8);
            result[p + 2] = (byte)v;
            p += 3;
            i += 4;
        }
        switch (pad) {
            case 2: {
                result[full + 1] = (byte)(table[s[i + 1]] << 4 | table[s[i + 2]] >> 2);
            }
            case 1: {
                result[full] = (byte)(table[s[i]] << 2 | table[s[i + 1]] >> 4);
            }
        }
        return result;
    }

    public static byte[] decodeFromChars(char[] s) {
        return Base64.decodeFromChars(s, s.length);
    }

    public static byte[] decodeFromChars(char[] s, int len) {
        while (len > 0 && s[len - 1] == '=') {
            --len;
        }
        int full = (len >> 2) * 3;
        int pad = (len & 3) * 3 >> 2;
        byte[] result = new byte[full + pad];
        byte[] table = DECODE_TABLE;
        int i = 0;
        int p = 0;
        while (p < full) {
            int v = table[s[i]] << 18 | table[s[i + 1]] << 12 | table[s[i + 2]] << 6 | table[s[i + 3]];
            result[p] = (byte)(v >>> 16);
            result[p + 1] = (byte)(v >>> 8);
            result[p + 2] = (byte)v;
            p += 3;
            i += 4;
        }
        switch (pad) {
            case 2: {
                result[full + 1] = (byte)(table[s[i + 1]] << 4 | table[s[i + 2]] >> 2);
            }
            case 1: {
                result[full] = (byte)(table[s[i]] << 2 | table[s[i + 1]] >> 4);
            }
        }
        return result;
    }
}

