/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.odkl;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.odkl.Evaluator;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.odkl.SparkSqlUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u00015\u00111CU3he\u0016\u001c8/[8o\u000bZ\fG.^1u_JT!a\u0001\u0003\u0002\t=$7\u000e\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0019q\u0002\u0005\n\u000e\u0003\tI!!\u0005\u0002\u0003\u0013\u00153\u0018\r\\;bi>\u0014\bCA\b\u0001\u0011!!\u0002A!b\u0001\n\u0003*\u0012aA;jIV\ta\u0003\u0005\u0002\u0018;9\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\u00051\u0001K]3eK\u001aL!AH\u0010\u0003\rM#(/\u001b8h\u0015\ta\u0012\u0004C\u0005\"\u0001\t\u0005\t\u0015!\u0003\u0017E\u0005!Q/\u001b3!\u0013\t!\u0002\u0003C\u0003%\u0001\u0011\u0005Q%\u0001\u0004=S:LGO\u0010\u000b\u0003%\u0019BQ\u0001F\u0012A\u0002YAq\u0001\u000b\u0001C\u0002\u0013\u0005\u0011&A\u0007uQJ|Wo\u001a5Pe&<\u0017N\\\u000b\u0002UA\u00111FL\u0007\u0002Y)\u0011Q\u0006B\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0003_1\u0012ABQ8pY\u0016\fg\u000eU1sC6Da!\r\u0001!\u0002\u0013Q\u0013A\u0004;ie>,x\r[(sS\u001eLg\u000e\t\u0005\u0006g\u0001!\t\u0001N\u0001\u0011g\u0016$H\u000b\u001b:pk\u001eDwJ]5hS:$\"!\u000e\u001c\u000e\u0003\u0001AQa\u000e\u001aA\u0002a\nQA^1mk\u0016\u0004\"\u0001G\u001d\n\u0005iJ\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006y\u0001!\t!P\u0001\u0011O\u0016$H\u000b\u001b:pk\u001eDwJ]5hS:,\u0012\u0001\u000f\u0005\u0006I\u0001!\ta\u0010\u000b\u0002%!)\u0011\t\u0001C!\u0005\u0006IAO]1og\u001a|'/\u001c\u000b\u0003\u0007^\u0003\"\u0001\u0012+\u000f\u0005\u0015\u000bfB\u0001$P\u001d\t9eJ\u0004\u0002I\u001b:\u0011\u0011\nT\u0007\u0002\u0015*\u00111\nD\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011B\u0001)\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003%N\u000bq\u0001]1dW\u0006<WM\u0003\u0002Q\r%\u0011QK\u0016\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!AU*\t\u000ba\u0003\u0005\u0019A-\u0002\u000f\u0011\fG/Y:fiB\u0012!\f\u0019\t\u00047rsV\"A*\n\u0005u\u001b&a\u0002#bi\u0006\u001cX\r\u001e\t\u0003?\u0002d\u0001\u0001B\u0005b/\u0006\u0005\t\u0011!B\u0001E\n\u0019q\fJ\u0019\u0012\u0005\r4\u0007C\u0001\re\u0013\t)\u0017DA\u0004O_RD\u0017N\\4\u0011\u0005a9\u0017B\u00015\u001a\u0005\r\te.\u001f\u0005\u0006U\u0002!\te[\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002\u0013Y\")Q.\u001ba\u0001]\u0006)Q\r\u001f;sCB\u00111f\\\u0005\u0003a2\u0012\u0001\u0002U1sC6l\u0015\r\u001d\u0005\u0006e\u0002!\te]\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR\u0011AO\u001f\t\u0003kbl\u0011A\u001e\u0006\u0003oN\u000bQ\u0001^=qKNL!!\u001f<\u0003\u0015M#(/^2u)f\u0004X\rC\u0003|c\u0002\u0007A/\u0001\u0004tG\",W.\u0019\u0015\u0003cv\u00042A`A\u0002\u001b\u0005y(bAA\u0001\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\u0015qP\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000e")
public class RegressionEvaluator
extends Evaluator<RegressionEvaluator> {
    private final BooleanParam throughOrigin = new BooleanParam((Identifiable)this, "throughOrigin", "True if the regression is through the origin. For example, in linear regression, it will be true without fitting intercept.");

    @Override
    public String uid() {
        return super.uid();
    }

    public BooleanParam throughOrigin() {
        return this.throughOrigin;
    }

    public RegressionEvaluator setThroughOrigin(boolean value) {
        return (RegressionEvaluator)this.set((Param)this.throughOrigin(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public boolean getThroughOrigin() {
        return BoxesRunTime.unboxToBoolean((Object)this.$((Param)this.throughOrigin()));
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        try {
            RDD predictions = dataset.select((String)this.$(this.predictionCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.$(this.labelCol())})).rdd().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(Row x0$1) {
                    Row row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                        Object score = ((SeqLike)some.get()).apply(0);
                        Object label = ((SeqLike)some.get()).apply(1);
                        if (score instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)score);
                            if (label instanceof Double) {
                                double d2 = BoxesRunTime.unboxToDouble((Object)label);
                                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
                                return sp2;
                            }
                        }
                    }
                    throw new MatchError((Object)row);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            Try metrics = Try$.MODULE$.apply((Function0)new Serializable(this, predictions){
                public static final long serialVersionUID = 0L;
                private final RDD predictions$1;

                public final RegressionMetrics apply() {
                    return new RegressionMetrics(this.predictions$1);
                }
                {
                    this.predictions$1 = predictions$1;
                }
            });
            Seq rows = (Seq)metrics.toOption().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Seq<Row> apply(RegressionMetrics m) {
                    return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)BoxesRunTime.boxToDouble((double)m.r2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rmse"), (Object)BoxesRunTime.boxToDouble((double)m.rootMeanSquaredError())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"explainedVariance"), (Object)BoxesRunTime.boxToDouble((double)m.explainedVariance())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"meanAbsoluteError"), (Object)BoxesRunTime.boxToDouble((double)m.meanAbsoluteError())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"meanSquaredError"), (Object)BoxesRunTime.boxToDouble((double)m.meanSquaredError()))}))).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Row apply(Product tuple) {
                            return Row$.MODULE$.fromTuple(tuple);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Seq<Nothing$> apply() {
                    return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                }
            });
            Object object = SparkSqlUtils$.MODULE$.reflectionLock();
            synchronized (object) {
                Dataset dataset3 = dataset.sqlContext().createDataFrame(dataset.sparkSession().sparkContext().parallelize(rows, 1, ClassTag$.MODULE$.apply(Row.class)), this.transformSchema(dataset.schema()));
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl9 : MonitorExitStatement: MONITOREXIT : var8_5
                dataset2 = dataset3;
            }
        }
        catch (Exception exception) {
            Dataset dataset4;
            this.logWarning((Function0)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to calculate metrics due to ").append((Object)this.e$1.getMessage()).toString();
                }
                {
                    this.e$1 = e$1;
                }
            });
            Object object = SparkSqlUtils$.MODULE$.reflectionLock();
            synchronized (object) {
                dataset4 = dataset.sqlContext().createDataFrame(dataset.sparkSession().sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), this.transformSchema(dataset.schema()));
            }
            dataset2 = dataset4;
        }
        return dataset2;
    }

    @Override
    public RegressionEvaluator copy(ParamMap extra) {
        return (RegressionEvaluator)this.copyValues((Params)new RegressionEvaluator(), extra);
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        return new StructType().add("metric", (DataType)StringType$.MODULE$, false).add("value", (DataType)DoubleType$.MODULE$, false);
    }

    public RegressionEvaluator(String uid) {
        super(uid);
    }

    public RegressionEvaluator() {
        this(Identifiable$.MODULE$.randomUID("regressionEvaluator"));
    }
}

