/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.base.deviceid;

import android.content.Context;
import android.content.SharedPreferences;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.base.io.FileUtils;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"FILE_DEVICE_ID", "", "KEY_DEVICE_ID", "NULL_UUID", "cachedDeviceId", "deviceIdLock", "Ljava/lang/Object;", "getDeviceId", "context", "Landroid/content/Context;", "loadDeviceId", "tracer-base_release"})
@JvmName(name="DeviceIdUtils")
public final class DeviceIdUtils {
    @NotNull
    public static final String NULL_UUID = "00000000-0000-0000-0000-000000000000";
    @NotNull
    private static final String KEY_DEVICE_ID = "device_id";
    @NotNull
    private static final String FILE_DEVICE_ID = "device_id.txt";
    @NotNull
    private static final Object deviceIdLock = new Object();
    @Nullable
    private static volatile String cachedDeviceId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String getDeviceId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String prevDeviceId = cachedDeviceId;
        if (prevDeviceId != null) {
            return prevDeviceId;
        }
        Object object = deviceIdLock;
        synchronized (object) {
            String loadedDeviceId;
            block5: {
                boolean bl = false;
                String syncDeviceId = cachedDeviceId;
                if (syncDeviceId == null) break block5;
                String string = syncDeviceId;
                return string;
            }
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            cachedDeviceId = loadedDeviceId = DeviceIdUtils.loadDeviceId(context2);
            String string = loadedDeviceId;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String loadDeviceId(Context context) {
        String oldDeviceId;
        String string;
        File file;
        SharedPreferences prefs = context.getSharedPreferences("tracer", 0);
        String prefsDeviceId = prefs.getString(KEY_DEVICE_ID, null);
        String string2 = prefsDeviceId;
        if (string2 == null) {
            string2 = NULL_UUID;
        }
        String fallbackDeviceId = string2;
        try {
            File file2 = context.getFilesDir();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"context.filesDir");
            file = FileUtils.mkdirsChecked(FilesKt.resolve((File)file2, (String)"tracer"));
        }
        catch (IOException ex) {
            return fallbackDeviceId;
        }
        File dir = file;
        File file3 = FilesKt.resolve((File)dir, (String)FILE_DEVICE_ID);
        if (!file3.exists()) {
            string = null;
        } else {
            String string3;
            try {
                String it = string3 = ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)file3, null, (int)1, null))).toString();
                boolean bl = false;
                string3 = ((CharSequence)it).length() > 0 ? string3 : null;
            }
            catch (IOException ex) {
                string3 = null;
            }
            string = oldDeviceId = string3;
        }
        if (oldDeviceId != null) {
            return oldDeviceId;
        }
        String string4 = prefsDeviceId;
        if (string4 == null) {
            String string5 = UUID.randomUUID().toString();
            string4 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"randomUUID().toString()");
        }
        String newDeviceId = string4;
        try {
            Closeable ex = new FileOutputStream(file3);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)ex;
                boolean bl = false;
                byte[] byArray = newDeviceId.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                it.write(byArray);
                it.getFD().sync();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)ex, (Throwable)throwable);
            }
        }
        catch (IOException ex) {
            return fallbackDeviceId;
        }
        if (prefsDeviceId != null) {
            prefs.edit().remove(KEY_DEVICE_ID).apply();
        }
        return newDeviceId;
    }
}

