/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.base.drop;

import android.util.Log;
import androidx.annotation.WorkerThread;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.PlatformRandomKt;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import ru.ok.tracer.base.drop.DropRecord;
import ru.ok.tracer.base.drop.DropRecordSerializer;
import ru.ok.tracer.base.io.FileUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0003\u001a\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lru/ok/tracer/base/drop/DropManager;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "dir", "lock", "Ljava/lang/Object;", "state", "Lru/ok/tracer/base/drop/DropManager$State;", "takenFile", "tmpFile", "drop", "", "event", "", "reason", "count", "", "records", "", "Lru/ok/tracer/base/drop/DropRecord;", "load", "", "save", "take", "Companion", "DropRecordComparator", "State", "tracer-base_release"})
public final class DropManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private final File dir;
    @NotNull
    private final File tmpFile;
    @NotNull
    private final File takenFile;
    @NotNull
    private volatile State state;
    @NotNull
    private final Object lock;
    private static final int DEFAULT_MAX_RECORDS_SIZE = 15;
    @NotNull
    private static final String EVENT_UNKNOWN = "unknown";
    @NotNull
    private static final String REASON_MAX_SIZE_EXCEEDED = "max_size_exceeded";

    public DropManager(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        File file2 = this.file.getParentFile();
        if (file2 == null) {
            DropManager dropManager = this;
            boolean bl = false;
            DropManager dropManager2 = dropManager;
            String string = "File " + this.file + " not in directory";
            throw new IllegalStateException(string.toString());
        }
        this.dir = file2;
        this.tmpFile = FilesKt.resolve((File)this.dir, (String)(this.file.getName() + ".tmp"));
        this.takenFile = FilesKt.resolve((File)this.dir, (String)(this.file.getName() + ".taken"));
        this.state = State.None.INSTANCE;
        this.lock = new Object();
    }

    @WorkerThread
    @JvmOverloads
    public final void drop(@NotNull String event, @NotNull String reason, int count) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.drop(CollectionsKt.listOf((Object)new DropRecord(event, reason, count)));
    }

    public static /* synthetic */ void drop$default(DropManager dropManager, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        dropManager.drop(string, string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void drop(@NotNull Collection<DropRecord> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        if (records.isEmpty()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            List list;
            boolean bl = false;
            State prevState = this.state;
            if (prevState instanceof State.Taken && records == ((State.Taken)prevState).getRecords()) {
                this.dir.mkdirs();
                this.takenFile.renameTo(this.file);
                this.state = new State.Loaded((List)records);
                return;
            }
            State currentState = this.state;
            if (currentState instanceof State.None) {
                list = this.load();
            } else if (currentState instanceof State.Loaded) {
                list = ((State.Loaded)currentState).getRecords();
            } else if (currentState instanceof State.Taken) {
                list = CollectionsKt.emptyList();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List currentRecords = list;
            List mergedRecords = ru.ok.tracer.base.drop.DropManager$Companion.merge$tracer_base_release$default(Companion, currentRecords, records, 0, 4, null);
            this.save(mergedRecords);
            this.state = new State.Loaded(mergedRecords);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    @NotNull
    public final Collection<DropRecord> take() {
        State prevState = this.state;
        if (prevState instanceof State.Loaded && ((State.Loaded)prevState).getRecords().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (prevState instanceof State.Taken) {
            return CollectionsKt.emptyList();
        }
        Object object = this.lock;
        synchronized (object) {
            List<DropRecord> list;
            boolean bl = false;
            State currentState = this.state;
            if (currentState instanceof State.None) {
                list = this.load();
            } else if (currentState instanceof State.Loaded) {
                list = ((State.Loaded)currentState).getRecords();
            } else {
                if (!(currentState instanceof State.Taken)) throw new NoWhenBranchMatchedException();
                return CollectionsKt.emptyList();
            }
            List<DropRecord> takeRecords = list;
            if (!((Collection)takeRecords).isEmpty()) {
                this.file.renameTo(this.takenFile);
                this.state = new State.Taken(takeRecords);
                return takeRecords;
            } else {
                this.state = new State.Loaded(CollectionsKt.emptyList());
            }
            return takeRecords;
        }
    }

    private final List<DropRecord> load() {
        if (!this.file.exists()) {
            return CollectionsKt.emptyList();
        }
        try {
            String text = FilesKt.readText$default((File)this.file, null, (int)1, null);
            JSONArray json = new JSONArray(text);
            return DropRecordSerializer.INSTANCE.fromJsonArray$tracer_base_release(json);
        }
        catch (JSONException ex) {
            Log.e((String)"Tracer", (String)("Couldn't read " + this.file), (Throwable)ex);
            try {
                FileUtils.deleteChecked(this.file);
            }
            catch (IOException ex2) {
                Log.e((String)"Tracer", (String)("Couldn't delete " + this.file));
            }
            return CollectionsKt.emptyList();
        }
        catch (IOException ex) {
            Log.e((String)"Tracer", (String)("Couldn't read " + this.file), (Throwable)ex);
            return CollectionsKt.emptyList();
        }
    }

    private final void save(List<DropRecord> records) {
        JSONArray json = DropRecordSerializer.INSTANCE.toJsonArray((Collection<DropRecord>)records);
        String string = json.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.toString()");
        String text = string;
        try {
            FileUtils.mkdirsChecked(this.dir);
            FilesKt.writeText$default((File)this.tmpFile, (String)text, null, (int)2, null);
            FileUtils.renameToChecked(this.tmpFile, this.file);
        }
        catch (IOException ex) {
            Log.e((String)"Tracer", (String)("Couldn't write " + this.file), (Throwable)ex);
            try {
                FileUtils.deleteChecked(this.file);
            }
            catch (IOException ex2) {
                Log.e((String)"Tracer", (String)("Couldn't delete " + this.file));
            }
        }
    }

    @WorkerThread
    @JvmOverloads
    public final void drop(@NotNull String event, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        DropManager.drop$default(this, event, reason, 0, 4, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J9\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0013J\u001e\u0010\u0014\u001a\u00020\u00152\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lru/ok/tracer/base/drop/DropManager$Companion;", "", "()V", "DEFAULT_MAX_RECORDS_SIZE", "", "EVENT_UNKNOWN", "", "REASON_MAX_SIZE_EXCEEDED", "compareRecord", "record", "Lru/ok/tracer/base/drop/DropRecord;", "withEvent", "withReason", "merge", "", "sortedRecords", "withRecords", "", "maxRecordsCount", "merge$tracer_base_release", "mergeInto", "", "", "tracer-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<DropRecord> merge$tracer_base_release(@NotNull List<DropRecord> sortedRecords, @NotNull Collection<DropRecord> withRecords, int maxRecordsCount) {
            List list;
            Intrinsics.checkNotNullParameter(sortedRecords, (String)"sortedRecords");
            Intrinsics.checkNotNullParameter(withRecords, (String)"withRecords");
            if (!(maxRecordsCount > 0)) {
                boolean $i$a$-check-DropManager$Companion$merge$22 = false;
                String $i$a$-check-DropManager$Companion$merge$22 = "maxRecordsCount <= 0";
                throw new IllegalStateException($i$a$-check-DropManager$Companion$merge$22.toString());
            }
            if (sortedRecords.isEmpty()) {
                return CollectionsKt.sortedWith((Iterable)withRecords, (Comparator)DropRecordComparator.INSTANCE);
            }
            if (withRecords.isEmpty()) {
                return sortedRecords;
            }
            List $this$merge_u24lambda_u241 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$merge_u24lambda_u241.addAll((Collection)sortedRecords);
            for (DropRecord record : withRecords) {
                Companion.mergeInto($this$merge_u24lambda_u241, record);
            }
            if ($this$merge_u24lambda_u241.size() > maxRecordsCount) {
                java.util.Random random = PlatformRandomKt.asJavaRandom((Random)((Random)Random.Default));
                int unknownCount = 0;
                while ($this$merge_u24lambda_u241.size() > maxRecordsCount - 1) {
                    int randomIndex = random.nextInt($this$merge_u24lambda_u241.size());
                    DropRecord removedRecord = (DropRecord)$this$merge_u24lambda_u241.remove(randomIndex);
                    unknownCount += removedRecord.getCount$tracer_base_release();
                }
                Companion.mergeInto($this$merge_u24lambda_u241, new DropRecord(DropManager.EVENT_UNKNOWN, DropManager.REASON_MAX_SIZE_EXCEEDED, unknownCount));
            }
            return CollectionsKt.build((List)list);
        }

        public static /* synthetic */ List merge$tracer_base_release$default(Companion companion, List list, Collection collection, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 15;
            }
            return companion.merge$tracer_base_release(list, collection, n);
        }

        private final void mergeInto(List<DropRecord> sortedRecords, DropRecord record) {
            int index = CollectionsKt.binarySearch$default(sortedRecords, (Object)record, (Comparator)DropRecordComparator.INSTANCE, (int)0, (int)0, (int)12, null);
            if (index >= 0) {
                sortedRecords.set(index, sortedRecords.get(index).copyIncrementCount$tracer_base_release(record.getCount$tracer_base_release()));
            } else {
                sortedRecords.add(-index - 1, record);
            }
        }

        private final int compareRecord(DropRecord record, String withEvent, String withReason) {
            int compareEvent = record.getEvent$tracer_base_release().compareTo(withEvent);
            if (compareEvent != 0) {
                return compareEvent;
            }
            int compareReason = record.getReason$tracer_base_release().compareTo(withReason);
            if (compareReason != 0) {
                return compareReason;
            }
            return 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lru/ok/tracer/base/drop/DropManager$DropRecordComparator;", "Ljava/util/Comparator;", "Lru/ok/tracer/base/drop/DropRecord;", "Lkotlin/Comparator;", "()V", "compare", "", "record", "withRecord", "tracer-base_release"})
    private static final class DropRecordComparator
    implements Comparator<DropRecord> {
        @NotNull
        public static final DropRecordComparator INSTANCE = new DropRecordComparator();

        private DropRecordComparator() {
        }

        @Override
        public int compare(@NotNull DropRecord record, @NotNull DropRecord withRecord) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            Intrinsics.checkNotNullParameter((Object)withRecord, (String)"withRecord");
            return Companion.compareRecord(record, withRecord.getEvent$tracer_base_release(), withRecord.getReason$tracer_base_release());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lru/ok/tracer/base/drop/DropManager$State;", "", "()V", "Loaded", "None", "Taken", "Lru/ok/tracer/base/drop/DropManager$State$Loaded;", "Lru/ok/tracer/base/drop/DropManager$State$None;", "Lru/ok/tracer/base/drop/DropManager$State$Taken;", "tracer-base_release"})
    private static abstract class State {
        private State() {
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lru/ok/tracer/base/drop/DropManager$State$None;", "Lru/ok/tracer/base/drop/DropManager$State;", "()V", "tracer-base_release"})
        public static final class None
        extends State {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/ok/tracer/base/drop/DropManager$State$Loaded;", "Lru/ok/tracer/base/drop/DropManager$State;", "records", "", "Lru/ok/tracer/base/drop/DropRecord;", "(Ljava/util/List;)V", "getRecords", "()Ljava/util/List;", "tracer-base_release"})
        public static final class Loaded
        extends State {
            @NotNull
            private final List<DropRecord> records;

            public Loaded(@NotNull List<DropRecord> records) {
                Intrinsics.checkNotNullParameter(records, (String)"records");
                super(null);
                this.records = records;
            }

            @NotNull
            public final List<DropRecord> getRecords() {
                return this.records;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R(\u0010\b\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0004 \n*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00030\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lru/ok/tracer/base/drop/DropManager$State$Taken;", "Lru/ok/tracer/base/drop/DropManager$State;", "records", "", "Lru/ok/tracer/base/drop/DropRecord;", "(Ljava/util/List;)V", "getRecords", "()Ljava/util/List;", "weakRecords", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "tracer-base_release"})
        public static final class Taken
        extends State {
            @NotNull
            private final WeakReference<List<DropRecord>> weakRecords;

            public Taken(@NotNull List<DropRecord> records) {
                Intrinsics.checkNotNullParameter(records, (String)"records");
                super(null);
                this.weakRecords = new WeakReference<List<DropRecord>>(records);
            }

            @Nullable
            public final List<DropRecord> getRecords() {
                return (List)this.weakRecords.get();
            }
        }
    }
}

