/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.base.io;

import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"deleteChecked", "Ljava/io/File;", "ensureDirs", "", "mkdirsChecked", "renameToChecked", "dest", "tracer-base_release"})
@JvmName(name="FileUtils")
public final class FileUtils {
    public static final boolean ensureDirs(@NotNull File $this$ensureDirs) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureDirs, (String)"<this>");
        return $this$ensureDirs.exists() || $this$ensureDirs.mkdirs();
    }

    @NotNull
    public static final File mkdirsChecked(@NotNull File $this$mkdirsChecked) throws IOException {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$mkdirsChecked, (String)"<this>");
        File $this$mkdirsChecked_u24lambda_u240 = file = $this$mkdirsChecked;
        boolean bl = false;
        if ($this$mkdirsChecked_u24lambda_u240.exists()) {
            if (!$this$mkdirsChecked_u24lambda_u240.isDirectory()) {
                throw new IOException($this$mkdirsChecked_u24lambda_u240 + " is not a directory");
            }
        } else if (!$this$mkdirsChecked_u24lambda_u240.mkdirs()) {
            throw new IOException("Can't create " + $this$mkdirsChecked_u24lambda_u240);
        }
        return file;
    }

    @NotNull
    public static final File deleteChecked(@NotNull File $this$deleteChecked) throws IOException {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$deleteChecked, (String)"<this>");
        File $this$deleteChecked_u24lambda_u241 = file = $this$deleteChecked;
        boolean bl = false;
        if ($this$deleteChecked_u24lambda_u241.exists() && !FilesKt.deleteRecursively((File)$this$deleteChecked_u24lambda_u241)) {
            throw new IOException("Can't delete " + $this$deleteChecked_u24lambda_u241);
        }
        return file;
    }

    @NotNull
    public static final File renameToChecked(@NotNull File $this$renameToChecked, @NotNull File dest) throws IOException {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$renameToChecked, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        File $this$renameToChecked_u24lambda_u242 = file = $this$renameToChecked;
        boolean bl = false;
        if (!$this$renameToChecked_u24lambda_u242.renameTo(dest)) {
            throw new IOException("Can't rename " + $this$renameToChecked_u24lambda_u242 + " to " + dest);
        }
        return file;
    }
}

