/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.base.apptoken;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.base.manifest.TracerManifestUtils;
import ru.ok.tracer.manifest.TracerManifest;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u001a%\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\u0001H\u0001\u00a2\u0006\u0002\u0010\r\u001a \u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\u0001H\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"NO_APP_TOKEN", "", "RESOURCE_NAME_APP_TOKEN", "RESOURCE_NAME_IS_DISABLED", "getAppToken", "context", "Landroid/content/Context;", "getHostAppToken", "isTracerBuildDisabled", "", "getBooleanOrNull", "name", "defPackage", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "getStringOrNull", "tracer-base_release"})
@JvmName(name="AppTokenUtils")
public final class AppTokenUtils {
    @NotNull
    private static final String NO_APP_TOKEN = "0000000000000000000000000000000000000000000";
    @NotNull
    private static final String RESOURCE_NAME_IS_DISABLED = "tracer_is_disabled";
    @NotNull
    private static final String RESOURCE_NAME_APP_TOKEN = "tracer_app_token";

    public static final boolean isTracerBuildDisabled(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Boolean bl = AppTokenUtils.getBooleanOrNull$default(context, RESOURCE_NAME_IS_DISABLED, null, 2, null);
        return bl != null ? bl : false;
    }

    @Nullable
    public static final String getHostAppToken(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Class<?> classTracer = Class.forName("ru.ok.tracer.Tracer");
            Field fieldInstance = classTracer.getField("INSTANCE");
            Method methodGetAppToken = classTracer.getMethod("getAppToken", new Class[0]);
            Object instance = fieldInstance.get(null);
            Object appToken = methodGetAppToken.invoke(instance, new Object[0]);
            return (String)appToken;
        }
        catch (Exception ex) {
            String string = context.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
            TracerManifest manifest = TracerManifestUtils.findTracerManifest(string);
            if (manifest != null) {
                return manifest.appToken();
            }
            String appToken = AppTokenUtils.getStringOrNull$default(context, RESOURCE_NAME_APP_TOKEN, null, 2, null);
            return appToken == null ? null : (Intrinsics.areEqual((Object)appToken, (Object)NO_APP_TOKEN) ? null : appToken);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getAppToken(@NotNull Context context) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String appToken = AppTokenUtils.getStringOrNull$default(context, RESOURCE_NAME_APP_TOKEN, null, 2, null);
        if (appToken == null) {
            throw new IllegalStateException("Could not find Tracer's appToken. Is Tracer plugin configured properly?");
        }
        return Intrinsics.areEqual((Object)appToken, (Object)NO_APP_TOKEN) ? null : var1_1;
    }

    @SuppressLint(value={"DiscouragedApi"})
    @Nullable
    public static final String getStringOrNull(@NotNull Context $this$getStringOrNull, @NotNull String name, @NotNull String defPackage) throws Resources.NotFoundException {
        Intrinsics.checkNotNullParameter((Object)$this$getStringOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defPackage, (String)"defPackage");
        Resources resources = $this$getStringOrNull.getResources();
        int id = resources.getIdentifier(name, "string", defPackage);
        return id == 0 ? null : resources.getString(id);
    }

    public static /* synthetic */ String getStringOrNull$default(Context context, String string, String string2, int n, Object object) throws Resources.NotFoundException {
        if ((n & 2) != 0) {
            String string3 = context.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"packageName");
            string2 = string3;
        }
        return AppTokenUtils.getStringOrNull(context, string, string2);
    }

    @SuppressLint(value={"DiscouragedApi"})
    @Nullable
    public static final Boolean getBooleanOrNull(@NotNull Context $this$getBooleanOrNull, @NotNull String name, @NotNull String defPackage) throws Resources.NotFoundException {
        Intrinsics.checkNotNullParameter((Object)$this$getBooleanOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defPackage, (String)"defPackage");
        Resources resources = $this$getBooleanOrNull.getResources();
        int id = resources.getIdentifier(name, "bool", defPackage);
        return id == 0 ? null : Boolean.valueOf(resources.getBoolean(id));
    }

    public static /* synthetic */ Boolean getBooleanOrNull$default(Context context, String string, String string2, int n, Object object) throws Resources.NotFoundException {
        if ((n & 2) != 0) {
            String string3 = context.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"packageName");
            string2 = string3;
        }
        return AppTokenUtils.getBooleanOrNull(context, string, string2);
    }
}

