/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.base.http;

import android.content.Context;
import android.net.TrafficStats;
import android.os.Build;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.base.cert.TrustManagerUtils;
import ru.ok.tracer.base.http.HttpByteArrayBody;
import ru.ok.tracer.base.http.HttpClient;
import ru.ok.tracer.base.http.HttpRequest;
import ru.ok.tracer.base.http.HttpRequestBody;
import ru.ok.tracer.base.http.HttpResponse;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000eH\u0002R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lru/ok/tracer/base/http/HttpUrlConnectionHttpClient;", "Lru/ok/tracer/base/http/HttpClient;", "context", "Landroid/content/Context;", "userAgent", "", "trafficStatsTag", "", "connectTimeout", "readTimeout", "(Landroid/content/Context;Ljava/lang/String;III)V", "connect", "", "conn", "Ljava/net/HttpURLConnection;", "execute", "Lru/ok/tracer/base/http/HttpResponse;", "request", "Lru/ok/tracer/base/http/HttpRequest;", "getResponseCode", "connection", "Companion", "tracer-base_release"})
public final class HttpUrlConnectionHttpClient
implements HttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private final String userAgent;
    private final int trafficStatsTag;
    private final int connectTimeout;
    private final int readTimeout;
    public static final int NO_TRAFFIC_STATS_TAG = -1;

    public HttpUrlConnectionHttpClient(@NotNull Context context, @Nullable String userAgent, int trafficStatsTag, int connectTimeout, int readTimeout) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.userAgent = userAgent;
        this.trafficStatsTag = trafficStatsTag;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public /* synthetic */ HttpUrlConnectionHttpClient(Context context, String string, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            string = null;
        }
        if ((n4 & 4) != 0) {
            n = -1;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        this(context, string, n, n2, n3);
    }

    private final int getResponseCode(HttpURLConnection connection) throws IOException {
        int n;
        try {
            n = connection.getResponseCode();
        }
        catch (ArrayIndexOutOfBoundsException okioFail) {
            throw new IOException(okioFail);
        }
        catch (NullPointerException okioFail) {
            String message = okioFail.getMessage();
            if (message != null && StringsKt.startsWith$default((String)message, (String)"Attempt to read from field 'int com.android.okhttp.okio.Segment.limit'", (boolean)false, (int)2, null)) {
                throw new IOException(okioFail);
            }
            throw okioFail;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public HttpResponse execute(@NotNull HttpRequest request) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String requestMethod = request.getMethod();
        String requestUrl = request.getUrl();
        HttpRequestBody requestBody = request.getBody();
        URLConnection uRLConnection = new URL(requestUrl).openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection conn = (HttpURLConnection)uRLConnection;
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(TrustManagerUtils.createSSLSocketFactory(TrustManagerUtils.createTracerTrustManager(this.context)));
        }
        try {
            Object object;
            Object it3;
            Throwable throwable;
            Closeable closeable;
            List<String> responseContentType;
            conn.setRequestMethod(requestMethod);
            if (this.userAgent != null) {
                conn.setRequestProperty("User-Agent", this.userAgent);
            }
            if (requestBody != null) {
                conn.setRequestProperty("Content-Type", requestBody.getContentType());
                conn.setDoOutput(true);
                if (requestBody.getContentLength() >= 0L) {
                    conn.setFixedLengthStreamingMode(requestBody.getContentLength());
                } else {
                    conn.setChunkedStreamingMode(4096);
                }
            }
            this.connect(conn, this.trafficStatsTag, this.connectTimeout, this.readTimeout);
            if (requestBody != null) {
                Closeable closeable2 = conn.getOutputStream();
                Throwable throwable2 = null;
                try {
                    OutputStream it2 = (OutputStream)closeable2;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                    requestBody.writeTo(it2);
                    it2 = Unit.INSTANCE;
                }
                catch (Throwable it2) {
                    throwable2 = it2;
                    throw it2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            int responseCode = this.getResponseCode(conn);
            String responseMessage = conn.getResponseMessage();
            List<String> list = conn.getHeaderFields().get("Content-Type");
            if (list == null || (list = (String)CollectionsKt.firstOrNull(list)) == null) {
                list = responseContentType = "application/octet-stream";
            }
            if (responseCode < 400) {
                InputStream inputStream = conn.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"conn.inputStream");
                closeable = inputStream;
                int n = 8192;
                closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                throwable = null;
                try {
                    it3 = (BufferedInputStream)closeable;
                    boolean bl = false;
                    it3 = ByteStreamsKt.readBytes((InputStream)((InputStream)it3));
                    object = it3;
                }
                catch (Throwable it3) {
                    throwable = it3;
                    throw it3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            InputStream inputStream = conn.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"conn.errorStream");
            closeable = inputStream;
            int n = 8192;
            closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
            throwable = null;
            try {
                it3 = (BufferedInputStream)closeable;
                boolean bl = false;
                byte[] byArray = ByteStreamsKt.readBytes((InputStream)((InputStream)it3));
                object = byArray;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object responseBytes = object;
            Intrinsics.checkNotNullExpressionValue((Object)responseMessage, (String)"responseMessage");
            return new HttpResponse(responseCode, responseMessage, new HttpByteArrayBody((String)((Object)responseContentType), (byte[])responseBytes));
        }
        catch (IOException th) {
            conn.disconnect();
            throw th;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void connect(HttpURLConnection conn, int trafficStatsTag, int connectTimeout, int readTimeout) throws IOException {
        int prevTrafficStatsTag = 0;
        if (trafficStatsTag != -1) {
            prevTrafficStatsTag = TrafficStats.getThreadStatsTag();
            TrafficStats.setThreadStatsTag((int)trafficStatsTag);
        } else {
            prevTrafficStatsTag = -1;
        }
        try {
            if (connectTimeout > 0) {
                conn.setConnectTimeout(connectTimeout);
            }
            if (readTimeout > 0) {
                conn.setReadTimeout(readTimeout);
            }
            conn.connect();
        }
        catch (SecurityException sex) {
            Throwable throwable = sex.getCause();
            if (throwable == null) {
                throw sex;
            }
            Throwable cause = throwable;
            String causeName = cause.getClass().getName();
            if (!Intrinsics.areEqual((Object)causeName, (Object)"libcore.io.GaiException") && !Intrinsics.areEqual((Object)causeName, (Object)"android.system.GaiException")) {
                throw sex;
            }
            throw new UnknownHostException();
        }
        catch (IllegalArgumentException ex) {
            if (Build.VERSION.SDK_INT <= 23 && Intrinsics.areEqual((Object)"timeout < 0", (Object)ex.getMessage())) {
                throw new IOException(ex);
            }
            throw ex;
        }
        catch (NullPointerException ex) {
            if (Build.VERSION.SDK_INT <= 23 && Intrinsics.areEqual((Object)"ssl_session == null", (Object)ex.getMessage())) {
                throw new IOException(ex);
            }
            throw ex;
        }
        finally {
            if (prevTrafficStatsTag != -1) {
                TrafficStats.setThreadStatsTag((int)prevTrafficStatsTag);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lru/ok/tracer/base/http/HttpUrlConnectionHttpClient$Companion;", "", "()V", "NO_TRAFFIC_STATS_TAG", "", "tracer-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

