/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.base.process;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import androidx.annotation.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0001\"\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"processName", "", "getProcessName", "context", "Landroid/content/Context;", "getSimpleProcessName", "simplifyProcessName", "packageName", "tracer-base_release"})
@JvmName(name="ProcessUtils")
public final class ProcessUtils {
    @Nullable
    private static volatile String processName;

    @NotNull
    public static final String getProcessName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = processName;
        if (string == null) {
            String string2;
            String it = string2 = ProcessUtils.getProcessName$readProcessName();
            boolean bl = false;
            processName = it;
            string = string2;
        }
        return string;
    }

    @Nullable
    public static final String getSimpleProcessName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = ProcessUtils.getProcessName(context);
        String string2 = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.packageName");
        return ProcessUtils.simplifyProcessName(string, string2);
    }

    @VisibleForTesting
    @Nullable
    public static final String simplifyProcessName(@Nullable String processName, @NotNull String packageName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (processName == null || Intrinsics.areEqual((Object)processName, (Object)packageName)) {
            return null;
        }
        int indexOfColon = StringsKt.indexOf$default((CharSequence)processName, (char)':', (int)0, (boolean)false, (int)6, null);
        if (indexOfColon == packageName.length() && StringsKt.startsWith$default((String)processName, (String)packageName, (boolean)false, (int)2, null)) {
            String string2 = processName.substring(indexOfColon);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string = processName;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getProcessName$readProcessName() {
        String string;
        if (Build.VERSION.SDK_INT >= 28) {
            String string2 = Application.getProcessName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            Applicatio\u2026etProcessName()\n        }");
        } else {
            Object object;
            try {
                String string3;
                object = new File("/proc/" + Process.myPid() + "/cmdline");
                Object object2 = Charsets.ISO_8859_1;
                object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
                object2 = null;
                try {
                    String string4;
                    block10: {
                        InputStreamReader reader = (InputStreamReader)object;
                        boolean bl = false;
                        String $this$takeWhile$iv = TextStreamsKt.readText((Reader)reader);
                        boolean $i$f$takeWhile = false;
                        int n = $this$takeWhile$iv.length();
                        for (int index$iv = 0; index$iv < n; ++index$iv) {
                            char it = $this$takeWhile$iv.charAt(index$iv);
                            boolean bl2 = false;
                            if (Intrinsics.compare((int)it, (int)0) > 0) continue;
                            String string5 = $this$takeWhile$iv;
                            int n2 = 0;
                            String string6 = string5.substring(n2, index$iv);
                            string4 = string6;
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            break block10;
                        }
                        string4 = $this$takeWhile$iv;
                    }
                    string3 = string4;
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                object = string3;
            }
            catch (Throwable th) {
                object = "unknown";
            }
            string = object;
        }
        return string;
    }
}

