/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.base.cert;

import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.RawRes;
import java.io.Closeable;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.base.R;
import ru.ok.tracer.base.cert.CompositeX509TrustManager;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\r\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0002\u001a!\u0010\r\u001a\u00020\u00012\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"createDefaultTrustManager", "Ljavax/net/ssl/X509TrustManager;", "createKeyStoreFromResource", "Ljava/security/KeyStore;", "context", "Landroid/content/Context;", "resId", "", "createSSLSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "trustManager", "Ljavax/net/ssl/TrustManager;", "createTracerTrustManager", "createTrustManager", "keyStore", "trustManagers", "", "([Ljavax/net/ssl/X509TrustManager;)Ljavax/net/ssl/X509TrustManager;", "tracer-base_release"})
@JvmName(name="TrustManagerUtils")
public final class TrustManagerUtils {
    @NotNull
    public static final X509TrustManager createTracerTrustManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        X509TrustManager[] x509TrustManagerArray = new X509TrustManager[]{TrustManagerUtils.createDefaultTrustManager(), TrustManagerUtils.createTrustManager(TrustManagerUtils.createKeyStoreFromResource(context, R.raw.rootca_ssl_rsa2022))};
        return TrustManagerUtils.createTrustManager(x509TrustManagerArray);
    }

    @NotNull
    public static final SSLSocketFactory createSSLSocketFactory(@NotNull TrustManager trustManager) {
        SSLContext sSLContext;
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        SSLContext $this$createSSLSocketFactory_u24lambda_u240 = sSLContext = SSLContext.getInstance("SSL");
        boolean bl = false;
        TrustManager[] trustManagerArray = new TrustManager[]{trustManager};
        $this$createSSLSocketFactory_u24lambda_u240.init(null, trustManagerArray, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"getInstance(\"SSL\")\n     \u2026 }\n        .socketFactory");
        return sSLSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final KeyStore createKeyStoreFromResource(Context context, @RawRes int resId) {
        KeyStore keyStore;
        Resources resources = context.getApplicationContext().getResources();
        Closeable closeable = resources.openRawResource(resId);
        Throwable throwable = null;
        try {
            Object input = (InputStream)closeable;
            boolean bl = false;
            input = CertificateFactory.getInstance("X509").generateCertificate((InputStream)input);
        }
        catch (Throwable input) {
            throwable = input;
            throw input;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object it = input;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        X509Certificate cert = (X509Certificate)it;
        String certName = resources.getResourceEntryName(resId);
        KeyStore $this$createKeyStoreFromResource_u24lambda_u243 = keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        boolean bl2 = false;
        $this$createKeyStoreFromResource_u24lambda_u243.load(null, null);
        $this$createKeyStoreFromResource_u24lambda_u243.setCertificateEntry(certName, cert);
        KeyStore keyStore2 = keyStore;
        Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"getInstance(KeyStore.get\u2026certName, cert)\n        }");
        return keyStore2;
    }

    private static final X509TrustManager createTrustManager(KeyStore keyStore) {
        TrustManagerFactory trustManagerFactory;
        TrustManagerFactory $this$createTrustManager_u24lambda_u244 = trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        boolean bl = false;
        $this$createTrustManager_u24lambda_u244.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNullExpressionValue((Object)trustManagerArray, (String)"getInstance(KeyManagerFa\u2026 }\n        .trustManagers");
        Object object = ArraysKt.first((Object[])trustManagerArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        return (X509TrustManager)object;
    }

    private static final X509TrustManager createDefaultTrustManager() {
        return TrustManagerUtils.createTrustManager(null);
    }

    private static final X509TrustManager createTrustManager(X509TrustManager ... trustManagers) {
        return new CompositeX509TrustManager(trustManagers);
    }
}

