/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.base.commands;

import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import ru.ok.tracer.base.limits.TracerFeatureLimits;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lru/ok/tracer/base/commands/CommandsHandler;", "", "builder", "Lru/ok/tracer/base/commands/CommandsHandler$Builder;", "(Lru/ok/tracer/base/commands/CommandsHandler$Builder;)V", "featureName", "", "limits", "Lru/ok/tracer/base/limits/TracerFeatureLimits;", "tag", "handleResponse", "", "responseContentType", "responseContent", "responseObject", "Lorg/json/JSONObject;", "Builder", "tracer-base_release"})
public final class CommandsHandler {
    @Nullable
    private final String featureName;
    @Nullable
    private final String tag;
    @Nullable
    private final TracerFeatureLimits limits;

    private CommandsHandler(Builder builder) {
        this.featureName = builder.getFeatureName$tracer_base_release();
        this.tag = builder.getTag$tracer_base_release();
        this.limits = builder.getLimits$tracer_base_release();
    }

    public final void handleResponse(@Nullable String responseContentType, @Nullable String responseContent) {
        JSONObject jSONObject;
        CharSequence charSequence = responseContent;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        try {
            jSONObject = new JSONObject(responseContent);
        }
        catch (Exception ex) {
            Log.w((String)"Tracer", (String)("Cannot parse content with Content-Type: " + responseContentType));
            return;
        }
        JSONObject responseJson = jSONObject;
        this.handleResponse(responseJson);
    }

    public final void handleResponse(@NotNull JSONObject responseObject) {
        Intrinsics.checkNotNullParameter((Object)responseObject, (String)"responseObject");
        JSONObject commandsObject = responseObject.optJSONObject("commands");
        if (commandsObject == null) {
            return;
        }
        if (this.limits != null) {
            long globalShutdownMs = commandsObject.optLong("globalShutdownMs");
            Long l = commandsObject.optLong("featureShutdownMs");
            long it = ((Number)l).longValue();
            boolean bl = false;
            Long featureShutdownMs = this.featureName != null ? l : null;
            Long l2 = commandsObject.optLong("tagShutdownMs");
            long it2 = ((Number)l2).longValue();
            boolean bl2 = false;
            Long tagShutdownMs = this.featureName != null && this.tag != null ? l2 : null;
            this.limits.setShutdownMs(globalShutdownMs, this.featureName, featureShutdownMs, this.tag, tagShutdownMs);
        }
    }

    public /* synthetic */ CommandsHandler(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0004R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\b\u00a8\u0006\u0017"}, d2={"Lru/ok/tracer/base/commands/CommandsHandler$Builder;", "", "()V", "featureName", "", "getFeatureName$tracer_base_release", "()Ljava/lang/String;", "setFeatureName$tracer_base_release", "(Ljava/lang/String;)V", "limits", "Lru/ok/tracer/base/limits/TracerFeatureLimits;", "getLimits$tracer_base_release", "()Lru/ok/tracer/base/limits/TracerFeatureLimits;", "setLimits$tracer_base_release", "(Lru/ok/tracer/base/limits/TracerFeatureLimits;)V", "tag", "getTag$tracer_base_release", "setTag$tracer_base_release", "build", "Lru/ok/tracer/base/commands/CommandsHandler;", "setFeatureName", "setLimitsHandler", "setTag", "tracer-base_release"})
    public static final class Builder {
        @Nullable
        private String featureName;
        @Nullable
        private String tag;
        @Nullable
        private TracerFeatureLimits limits;

        @Nullable
        public final String getFeatureName$tracer_base_release() {
            return this.featureName;
        }

        public final void setFeatureName$tracer_base_release(@Nullable String string) {
            this.featureName = string;
        }

        @Nullable
        public final String getTag$tracer_base_release() {
            return this.tag;
        }

        public final void setTag$tracer_base_release(@Nullable String string) {
            this.tag = string;
        }

        @Nullable
        public final TracerFeatureLimits getLimits$tracer_base_release() {
            return this.limits;
        }

        public final void setLimits$tracer_base_release(@Nullable TracerFeatureLimits tracerFeatureLimits) {
            this.limits = tracerFeatureLimits;
        }

        @NotNull
        public final Builder setFeatureName(@NotNull String featureName) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
            Builder $this$setFeatureName_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$setFeatureName_u24lambda_u240.featureName = featureName;
            return builder;
        }

        @NotNull
        public final Builder setTag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$setTag_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$setTag_u24lambda_u241.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder setLimitsHandler(@NotNull TracerFeatureLimits limits) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)limits, (String)"limits");
            Builder $this$setLimitsHandler_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$setLimitsHandler_u24lambda_u242.limits = limits;
            return builder;
        }

        @NotNull
        public final CommandsHandler build() {
            return new CommandsHandler(this, null);
        }
    }
}

