/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.base.stacktrace;

import java.util.IdentityHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0007\u001a-\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a#\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u001c\u0010\f\u001a\u00060\rj\u0002`\u000e*\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0010\u001a\u00020\u0011*\u00020\t2\n\u0010\u0012\u001a\u00060\rj\u0002`\u000e\u001a]\u0010\u0010\u001a\u00020\u0011*\u00020\t2\n\u0010\u0012\u001a\u00060\rj\u0002`\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u00142\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a*\u0010\u0018\u001a\u00020\u0011*\u00020\u00042\n\u0010\u0012\u001a\u00060\rj\u0002`\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a,\u0010\u0019\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u001a*\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\u001b\u001a\u0002H\u001aH\u0082\u0002\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"framesInCommon", "", "a", "", "Ljava/lang/StackTraceElement;", "b", "([Ljava/lang/StackTraceElement;[Ljava/lang/StackTraceElement;)I", "framesRepeat", "ex", "", "trace", "(Ljava/lang/Throwable;[Ljava/lang/StackTraceElement;)I", "appendIndent", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "indent", "appendStackTraceTo", "", "out", "prefix", "", "visited", "", "(Ljava/lang/Throwable;Ljava/lang/Appendable;ILjava/lang/String;[Ljava/lang/StackTraceElement;ILjava/util/Map;)V", "appendTo", "plusAssign", "T", "key", "(Ljava/util/Map;Ljava/lang/Object;)V", "tracer-base_release"})
@JvmName(name="ThrowableUtils")
public final class ThrowableUtils {
    public static final void appendStackTraceTo(@NotNull Throwable $this$appendStackTraceTo, @NotNull Appendable out) {
        Intrinsics.checkNotNullParameter((Object)$this$appendStackTraceTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        StackTraceElement[] stackTraceElementArray = $this$appendStackTraceTo.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"stackTrace");
        ThrowableUtils.appendStackTraceTo$default($this$appendStackTraceTo, out, 0, null, stackTraceElementArray, 0, new IdentityHashMap(), 22, null);
    }

    private static final void appendStackTraceTo(Throwable $this$appendStackTraceTo, Appendable out, int indent, String prefix, StackTraceElement[] trace, int framesInCommon, Map<Throwable, Unit> visited) {
        if (visited.containsKey($this$appendStackTraceTo)) {
            Appendable appendable = ThrowableUtils.appendIndent(out, 1).append("[CIRCULAR REFERENCE: ").append($this$appendStackTraceTo.toString()).append("]");
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"out.appendIndent(1)\n    \u2026s.toString()).append(\"]\")");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
            return;
        }
        ThrowableUtils.plusAssign(visited, $this$appendStackTraceTo);
        Appendable appendable = ThrowableUtils.appendIndent(out, indent).append(prefix).append($this$appendStackTraceTo.toString());
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"out.appendIndent(indent)\u2026).append(this.toString())");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
        int framesRepeat = ThrowableUtils.framesRepeat($this$appendStackTraceTo, trace);
        int framesCount = framesRepeat > 0 ? framesRepeat : trace.length - framesInCommon;
        for (int i = 0; i < framesCount; ++i) {
            StackTraceElement element = trace[i];
            ThrowableUtils.appendTo$default(element, out, indent + 1, null, 4, null);
        }
        if (framesRepeat > 0) {
            Appendable appendable2 = ThrowableUtils.appendIndent(out, indent + 1).append("... ").append(String.valueOf(framesRepeat)).append(" calls repeat");
            Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"out.appendIndent(indent \u2026).append(\" calls repeat\")");
            Intrinsics.checkNotNullExpressionValue((Object)appendable2.append('\n'), (String)"append('\\n')");
        } else if (framesInCommon != 0) {
            Appendable appendable3 = ThrowableUtils.appendIndent(out, indent + 1).append("... ").append(String.valueOf(framesInCommon)).append(" more");
            Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"out.appendIndent(indent \u2026String()).append(\" more\")");
            Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append('\\n')");
        }
        Throwable[] throwableArray = $this$appendStackTraceTo.getSuppressed();
        Intrinsics.checkNotNullExpressionValue((Object)throwableArray, (String)"suppressed");
        for (Throwable supp : throwableArray) {
            StackTraceElement[] suppTrace = supp.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)supp, (String)"supp");
            Intrinsics.checkNotNullExpressionValue((Object)suppTrace, (String)"suppTrace");
            ThrowableUtils.appendStackTraceTo(supp, out, indent + 1, "Suppressed: ", suppTrace, ThrowableUtils.framesInCommon(trace, suppTrace), visited);
        }
        Throwable cause = $this$appendStackTraceTo.getCause();
        if (cause != null) {
            StackTraceElement[] causeTrace = cause.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)causeTrace, (String)"causeTrace");
            ThrowableUtils.appendStackTraceTo(cause, out, indent, "Caused by: ", causeTrace, ThrowableUtils.framesInCommon(trace, causeTrace), visited);
        }
    }

    static /* synthetic */ void appendStackTraceTo$default(Throwable throwable, Appendable appendable, int n, String string, StackTraceElement[] stackTraceElementArray, int n2, Map map, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            string = "";
        }
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        ThrowableUtils.appendStackTraceTo(throwable, appendable, n, string, stackTraceElementArray, n2, map);
    }

    private static final int framesRepeat(Throwable ex, StackTraceElement[] trace) {
        if (ex instanceof StackOverflowError) {
            StackTraceElement top = trace[0];
            int n = trace.length;
            for (int i = 1; i < n; ++i) {
                if (!Intrinsics.areEqual((Object)top, (Object)trace[i])) continue;
                return i;
            }
        }
        return 0;
    }

    public static final void appendTo(@NotNull StackTraceElement $this$appendTo, @NotNull Appendable out, int indent, @NotNull String prefix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$appendTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        ThrowableUtils.appendIndent(out, indent).append(prefix);
        if ($this$appendTo.isNativeMethod()) {
            string = "Native Method";
        } else {
            string = $this$appendTo.getFileName();
            if (string == null) {
                string = "Unknown Source";
            }
        }
        String fileName = string;
        out.append($this$appendTo.getClassName()).append(".").append($this$appendTo.getMethodName()).append("(").append(fileName);
        if ($this$appendTo.getLineNumber() >= 0) {
            out.append(":").append(String.valueOf($this$appendTo.getLineNumber()));
        }
        Appendable appendable = out.append(")");
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"out.append(\")\")");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
    }

    public static /* synthetic */ void appendTo$default(StackTraceElement stackTraceElement, Appendable appendable, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        if ((n2 & 4) != 0) {
            string = "at ";
        }
        ThrowableUtils.appendTo(stackTraceElement, appendable, n, string);
    }

    private static final Appendable appendIndent(Appendable $this$appendIndent, int indent) {
        Appendable appendable;
        Appendable $this$appendIndent_u24lambda_u240 = appendable = $this$appendIndent;
        boolean bl = false;
        for (int i = 0; i < indent; ++i) {
            $this$appendIndent_u24lambda_u240.append("\t");
        }
        return appendable;
    }

    private static final int framesInCommon(StackTraceElement[] a, StackTraceElement[] b) {
        int m = ArraysKt.getLastIndex((Object[])a);
        for (int n = ArraysKt.getLastIndex((Object[])b); m >= 0 && n >= 0 && Intrinsics.areEqual((Object)a[m], (Object)b[n]); --m, --n) {
        }
        return ArraysKt.getLastIndex((Object[])a) - m;
    }

    private static final <T> void plusAssign(Map<T, Unit> $this$plusAssign, T key) {
        Intrinsics.checkNotNullParameter($this$plusAssign, (String)"<this>");
        $this$plusAssign.put(key, Unit.INSTANCE);
    }
}

