/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.utils;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lru/ok/tracer/utils/SequentialExecutor;", "Ljava/util/concurrent/Executor;", "delegate", "(Ljava/util/concurrent/Executor;)V", "atomicQueue", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Ljava/lang/Runnable;", "queueRunnable", "Lru/ok/tracer/utils/SequentialExecutor$QueueRunnable;", "execute", "", "command", "run", "Companion", "QueueRunnable", "tracer-commons_release"})
public final class SequentialExecutor
implements Executor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Executor delegate;
    @NotNull
    private final AtomicReference<List<Runnable>> atomicQueue;
    @NotNull
    private final QueueRunnable queueRunnable;

    public SequentialExecutor(@NotNull Executor delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.atomicQueue = new AtomicReference<List>(CollectionsKt.emptyList());
        this.queueRunnable = new QueueRunnable();
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        boolean isFirst = SequentialExecutor.Companion.push(this.atomicQueue, command);
        if (isFirst) {
            this.delegate.execute(this.queueRunnable);
        }
    }

    private final void run() {
        while (true) {
            Throwable throwable;
            Object object;
            Runnable command;
            List<Runnable> list = this.atomicQueue.get();
            Intrinsics.checkNotNullExpressionValue(list, (String)"atomicQueue.get()");
            if ((Runnable)CollectionsKt.firstOrNull(list) == null) break;
            SequentialExecutor sequentialExecutor = this;
            try {
                SequentialExecutor $this$run_u24lambda_u240 = sequentialExecutor;
                boolean bl = false;
                command.run();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Object result = object;
            boolean isLast = SequentialExecutor.Companion.pop(this.atomicQueue, command);
            object = result;
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) continue;
            Throwable it = throwable = throwable3;
            boolean bl = false;
            if (!isLast) {
                this.delegate.execute(this.queueRunnable);
            }
            throw it;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lru/ok/tracer/utils/SequentialExecutor$QueueRunnable;", "Ljava/lang/Runnable;", "(Lru/ok/tracer/utils/SequentialExecutor;)V", "run", "", "tracer-commons_release"})
    private final class QueueRunnable
    implements Runnable {
        @Override
        public void run() {
            SequentialExecutor.this.run();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u00070\u00062\u0006\u0010\b\u001a\u0002H\u0005H\u0002\u00a2\u0006\u0002\u0010\tJ+\u0010\n\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u00070\u00062\u0006\u0010\b\u001a\u0002H\u0005H\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u000b"}, d2={"Lru/ok/tracer/utils/SequentialExecutor$Companion;", "", "()V", "pop", "", "T", "Ljava/util/concurrent/atomic/AtomicReference;", "", "item", "(Ljava/util/concurrent/atomic/AtomicReference;Ljava/lang/Object;)Z", "push", "tracer-commons_release"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> boolean push(AtomicReference<List<T>> $this$push, T item) {
            List next;
            List<T> prev;
            do {
                prev = $this$push.get();
                Intrinsics.checkNotNullExpressionValue(prev, (String)"prev");
            } while (!$this$push.compareAndSet(prev, next = CollectionsKt.plus((Collection)prev, item)));
            return prev.isEmpty();
        }

        private final <T> boolean pop(AtomicReference<List<T>> $this$pop, T item) {
            List next;
            List<T> prev;
            do {
                if (!((prev = $this$pop.get()).get(0) == item)) {
                    boolean bl = false;
                    String string = "Did someone mess with the queue?";
                    throw new IllegalStateException(string.toString());
                }
                Intrinsics.checkNotNullExpressionValue(prev, (String)"prev");
            } while (!$this$pop.compareAndSet(prev, next = CollectionsKt.drop((Iterable)prev, (int)1)));
            return next.isEmpty();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

