/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.session;

import android.content.Context;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.LogLevel;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.base.io.FileUtils;
import ru.ok.tracer.session.SessionState;
import ru.ok.tracer.session.SessionStateStorageKt;
import ru.ok.tracer.session.SystemStateUtils;
import ru.ok.tracer.utils.SimpleFileKeyValueStorage;
import ru.ok.tracer.utils.TracerFiles;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\u0018\u0000 I2\u00020\u0001:\u0001IB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010<\u001a\u00020=J\u0010\u0010>\u001a\u00020=2\b\u0010?\u001a\u0004\u0018\u00010@J\b\u0010A\u001a\u00020=H\u0002J(\u0010B\u001a\u00020=2\b\b\u0002\u0010C\u001a\u00020\n2\b\b\u0002\u0010D\u001a\u00020\u00172\n\b\u0002\u0010?\u001a\u0004\u0018\u00010@H\u0002J#\u0010E\u001a\u00020=2\u0014\u0010F\u001a\u0010\u0012\u0004\u0012\u000206\u0012\u0006\u0012\u0004\u0018\u0001060GH\u0000\u00a2\u0006\u0002\bHR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u00178@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010 \u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R$\u0010(\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\r\"\u0004\b*\u0010\u000fR\u0011\u0010+\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010/\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0014R\u0010\u00101\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00102\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b3\u0010-R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\b0%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u00107\u001a\u0004\u0018\u0001062\b\u0010\t\u001a\u0004\u0018\u0001068@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b8\u00109\"\u0004\b:\u0010;\u00a8\u0006J"}, d2={"Lru/ok/tracer/session/SessionStateStorage;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "currSystemStateData", "Lru/ok/tracer/SystemState;", "currentSessionStateData", "Lru/ok/tracer/session/SessionState;", "value", "Lru/ok/tracer/session/SessionState$Status;", "currentSessionStatus", "getCurrentSessionStatus", "()Lru/ok/tracer/session/SessionState$Status;", "setCurrentSessionStatus", "(Lru/ok/tracer/session/SessionState$Status;)V", "currentStartTs", "", "currentSystemState", "getCurrentSystemState", "()Lru/ok/tracer/SystemState;", "fileStorage", "Lru/ok/tracer/utils/SimpleFileKeyValueStorage;", "", "isCurrentlyInBackground", "isCurrentlyInBackground$tracer_commons_release", "()Z", "setCurrentlyInBackground$tracer_commons_release", "(Z)V", "loaded", "lock", "Ljava/lang/Object;", "prevSessionState", "getPrevSessionState", "()Lru/ok/tracer/session/SessionState;", "prevSessionStateData", "prevSessionStates", "", "getPrevSessionStates", "()Ljava/util/List;", "prevSessionStatus", "getPrevSessionStatus", "setPrevSessionStatus", "prevStartTs", "getPrevStartTs", "()J", "prevStartTsData", "prevSystemState", "getPrevSystemState", "prevSystemStateData", "sessionStateUploadTs", "getSessionStateUploadTs", "sessionStatesData", "sessionStatesUploadTsData", "", "userId", "getUserId$tracer_commons_release", "()Ljava/lang/String;", "setUserId$tracer_commons_release", "(Ljava/lang/String;)V", "consumePrevSessionStates", "", "ensureCurrentSessionMaxLogLevel", "maxLogLevel", "Lru/ok/tracer/LogLevel;", "ensureLoaded", "setCurrentSessionState", "status", "isInBackground", "setCustomProperties", "properties", "", "setCustomProperties$tracer_commons_release", "Companion", "tracer-commons_release"})
public final class SessionStateStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Object lock;
    @NotNull
    private final SimpleFileKeyValueStorage fileStorage;
    private volatile boolean loaded;
    private final long currentStartTs;
    private SystemState currSystemStateData;
    private long prevStartTsData;
    @Nullable
    private SystemState prevSystemStateData;
    private long sessionStatesUploadTsData;
    @NotNull
    private List<SessionState> sessionStatesData;
    private volatile SessionState currentSessionStateData;
    @Nullable
    private volatile SessionState prevSessionStateData;
    private static final int MAX_SESSIONS = 50;
    @NotNull
    private static final String SESSION_SYSTEM_STATE = "session_system_state";
    @NotNull
    private static final String SESSION_START_TS = "session_start_ts";
    @NotNull
    private static final String SESSION_STATE_UPLOAD_TS = "session_state_upload_ts";
    @NotNull
    private static final String SESSION_STATES = "session_states";
    @NotNull
    private static final String PROPERTY_KEY_USER_ID = "userId";
    private static final int MAX_CUSTOM_PROPERTY_KEY_LENGTH = 32;
    private static final int MAX_CUSTOM_PROPERTY_VALUE_LENGTH = 64;

    public SessionStateStorage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.lock = new Object();
        this.fileStorage = new SimpleFileKeyValueStorage((Function0<? extends File>)((Function0)new Function0<File>(this){
            final /* synthetic */ SessionStateStorage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return FilesKt.resolve((File)FileUtils.mkdirsChecked((File)TracerFiles.INSTANCE.getTracerDir(SessionStateStorage.access$getContext$p(this.this$0))), (String)"session.data");
            }
        }));
        this.currentStartTs = System.currentTimeMillis();
        this.prevStartTsData = Long.MIN_VALUE;
        this.sessionStatesUploadTsData = Long.MIN_VALUE;
        this.sessionStatesData = CollectionsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureLoaded() {
        if (!this.loaded) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                if (!this.loaded) {
                    Long l = this.fileStorage.getLong(SESSION_START_TS);
                    this.prevStartTsData = l != null ? l : Long.MIN_VALUE;
                    this.prevSystemStateData = SessionStateStorageKt.access$getSystemState(this.fileStorage, SESSION_SYSTEM_STATE);
                    SystemState systemState = this.prevSystemStateData;
                    this.currSystemStateData = SessionStateStorageKt.access$withPrevProperties(SystemStateUtils.createSystemState(this.context), systemState != null ? systemState.getProperties() : null);
                    Long l2 = this.fileStorage.getLong(SESSION_STATE_UPLOAD_TS);
                    this.sessionStatesUploadTsData = l2 != null ? l2 : Long.MIN_VALUE;
                    Collection collection = SessionStateStorageKt.access$getSessionStates(this.fileStorage, SESSION_STATES);
                    SystemState systemState2 = this.currSystemStateData;
                    if (systemState2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"currSystemStateData");
                        systemState2 = null;
                    }
                    this.sessionStatesData = CollectionsKt.takeLast((List)CollectionsKt.plus((Collection)collection, (Object)SessionState.Companion.invoke$tracer_commons_release(systemState2)), (int)50);
                    int sessionStatesSize = this.sessionStatesData.size();
                    this.currentSessionStateData = (SessionState)CollectionsKt.last(this.sessionStatesData);
                    this.prevSessionStateData = sessionStatesSize > 1 ? this.sessionStatesData.get(sessionStatesSize - 2) : (SessionState)null;
                    this.fileStorage.putLong(SESSION_START_TS, this.currentStartTs);
                    SystemState systemState3 = this.currSystemStateData;
                    if (systemState3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"currSystemStateData");
                        systemState3 = null;
                    }
                    SessionStateStorageKt.access$putSystemState(this.fileStorage, SESSION_SYSTEM_STATE, systemState3);
                    SessionStateStorageKt.access$putSessionStates(this.fileStorage, SESSION_STATES, this.sessionStatesData);
                    this.fileStorage.save();
                    this.loaded = true;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final long getPrevStartTs() {
        this.ensureLoaded();
        return this.prevStartTsData;
    }

    @Nullable
    public final SystemState getPrevSystemState() {
        this.ensureLoaded();
        return this.prevSystemStateData;
    }

    @NotNull
    public final SystemState getCurrentSystemState() {
        this.ensureLoaded();
        SystemState systemState = this.currSystemStateData;
        if (systemState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currSystemStateData");
            systemState = null;
        }
        return systemState.withCurrentDate$tracer_commons_release();
    }

    public final boolean isCurrentlyInBackground$tracer_commons_release() {
        this.ensureLoaded();
        SystemState systemState = this.currSystemStateData;
        if (systemState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currSystemStateData");
            systemState = null;
        }
        return systemState.isInBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCurrentlyInBackground$tracer_commons_release(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            SystemState systemState;
            boolean bl = false;
            this.ensureLoaded();
            SystemState systemState2 = this.currSystemStateData;
            if (systemState2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currSystemStateData");
                systemState2 = null;
            }
            if (systemState2.isInBackground() == value) {
                return;
            }
            SystemState systemState3 = this.currSystemStateData;
            if (systemState3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currSystemStateData");
                systemState3 = null;
            }
            if ((systemState = (this.currSystemStateData = SystemState.copy$default(systemState3, null, 0L, null, null, null, null, null, null, null, null, value, false, null, null, 15359, null))) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currSystemStateData");
                systemState = null;
            }
            SessionStateStorageKt.access$putSystemState(this.fileStorage, SESSION_SYSTEM_STATE, systemState);
            SessionStateStorage.setCurrentSessionState$default(this, null, value, null, 5, null);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final String getUserId$tracer_commons_release() {
        this.ensureLoaded();
        SystemState systemState = this.currSystemStateData;
        if (systemState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currSystemStateData");
            systemState = null;
        }
        return systemState.getProperties().get(PROPERTY_KEY_USER_ID);
    }

    public final void setUserId$tracer_commons_release(@Nullable String value) {
        this.setCustomProperties$tracer_commons_release(MapsKt.mapOf((Pair)TuplesKt.to((Object)PROPERTY_KEY_USER_ID, (Object)value)));
    }

    @Nullable
    public final SessionState getPrevSessionState() {
        this.ensureLoaded();
        return this.prevSessionStateData;
    }

    @NotNull
    public final SessionState.Status getPrevSessionStatus() {
        Object object = this.getPrevSessionState();
        if (object == null || (object = object.getStatus()) == null) {
            object = SessionState.Status.BLANK;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPrevSessionStatus(@NotNull SessionState.Status value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.ensureLoaded();
        SessionState sessionState = this.prevSessionStateData;
        if (sessionState != null) {
            SessionState prev = sessionState;
            boolean bl = false;
            Object object = this.lock;
            synchronized (object) {
                SessionState newPrevSessionState;
                boolean bl2 = false;
                this.ensureLoaded();
                this.prevSessionStateData = newPrevSessionState = SessionState.copy$default(prev, 0L, null, null, null, null, value, null, false, 223, null);
                if (this.sessionStatesData.size() <= 1) {
                    return;
                }
                this.sessionStatesData = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.dropLast(this.sessionStatesData, (int)2), (Object)newPrevSessionState), (Object)CollectionsKt.last(this.sessionStatesData));
                SessionStateStorageKt.access$putSessionStates(this.fileStorage, SESSION_STATES, this.sessionStatesData);
                this.fileStorage.save();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @NotNull
    public final SessionState.Status getCurrentSessionStatus() {
        this.ensureLoaded();
        SessionState sessionState = this.currentSessionStateData;
        if (sessionState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentSessionStateData");
            sessionState = null;
        }
        return sessionState.getStatus();
    }

    public final void setCurrentSessionStatus(@NotNull SessionState.Status value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        SessionStateStorage.setCurrentSessionState$default(this, value, false, null, 6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureCurrentSessionMaxLogLevel(@Nullable LogLevel maxLogLevel) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.ensureLoaded();
            Comparable comparable = maxLogLevel;
            SessionState sessionState = this.currentSessionStateData;
            if (sessionState == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentSessionStateData");
                sessionState = null;
            }
            if (SessionStateStorageKt.access$compareToNullLast(comparable, sessionState.getMaxLogLevel()) > 0) {
                SessionStateStorage.setCurrentSessionState$default(this, null, false, maxLogLevel, 3, null);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setCurrentSessionState(SessionState.Status status, boolean isInBackground, LogLevel maxLogLevel) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.ensureLoaded();
            SessionState sessionState = this.currentSessionStateData;
            if (sessionState == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentSessionStateData");
                sessionState = null;
            }
            this.currentSessionStateData = SessionState.copy$default(sessionState, 0L, null, null, null, null, status, maxLogLevel, isInBackground, 31, null);
            Collection collection = CollectionsKt.dropLast(this.sessionStatesData, (int)1);
            SessionState sessionState2 = this.currentSessionStateData;
            if (sessionState2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentSessionStateData");
                sessionState2 = null;
            }
            this.sessionStatesData = CollectionsKt.plus((Collection)collection, (Object)sessionState2);
            SessionStateStorageKt.access$putSessionStates(this.fileStorage, SESSION_STATES, this.sessionStatesData);
            this.fileStorage.save();
            Unit unit = Unit.INSTANCE;
        }
    }

    static /* synthetic */ void setCurrentSessionState$default(SessionStateStorage sessionStateStorage, SessionState.Status status, boolean bl, LogLevel logLevel, int n, Object object) {
        if ((n & 1) != 0) {
            SessionState sessionState = sessionStateStorage.currentSessionStateData;
            if (sessionState == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentSessionStateData");
                sessionState = null;
            }
            status = sessionState.getStatus();
        }
        if ((n & 2) != 0) {
            SessionState sessionState = sessionStateStorage.currentSessionStateData;
            if (sessionState == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentSessionStateData");
                sessionState = null;
            }
            bl = sessionState.isInBackground();
        }
        if ((n & 4) != 0) {
            SessionState sessionState = sessionStateStorage.currentSessionStateData;
            if (sessionState == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentSessionStateData");
                sessionState = null;
            }
            logLevel = sessionState.getMaxLogLevel();
        }
        sessionStateStorage.setCurrentSessionState(status, bl, logLevel);
    }

    public final long getSessionStateUploadTs() {
        this.ensureLoaded();
        return this.sessionStatesUploadTsData;
    }

    @NotNull
    public final List<SessionState> getPrevSessionStates() {
        this.ensureLoaded();
        return CollectionsKt.dropLast(this.sessionStatesData, (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCustomProperties$tracer_commons_release(@NotNull Map<String, String> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Object object = this.lock;
        synchronized (object) {
            SystemState systemState;
            boolean bl = false;
            this.ensureLoaded();
            boolean modified = false;
            SystemState systemState2 = this.currSystemStateData;
            if (systemState2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currSystemStateData");
                systemState2 = null;
            }
            Map mutableProperties = MapsKt.toMutableMap(systemState2.getProperties());
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String string = value;
                modified = SessionStateStorageKt.access$update(mutableProperties, StringsKt.take((String)key, (int)32), string != null ? StringsKt.take((String)string, (int)64) : null);
            }
            if (!modified) {
                return;
            }
            SystemState systemState3 = this.currSystemStateData;
            if (systemState3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currSystemStateData");
                systemState3 = null;
            }
            if ((systemState = (this.currSystemStateData = SystemState.copy$default(systemState3, null, 0L, null, null, null, null, null, null, null, null, false, false, mutableProperties, null, 12287, null))) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currSystemStateData");
                systemState = null;
            }
            SessionStateStorageKt.access$putSystemState(this.fileStorage, SESSION_SYSTEM_STATE, systemState);
            this.fileStorage.save();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void consumePrevSessionStates() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.ensureLoaded();
            this.sessionStatesUploadTsData = this.currentStartTs;
            this.sessionStatesData = CollectionsKt.listOf((Object)CollectionsKt.last(this.sessionStatesData));
            this.fileStorage.putLong(SESSION_STATE_UPLOAD_TS, this.sessionStatesUploadTsData);
            SessionStateStorageKt.access$putSessionStates(this.fileStorage, SESSION_STATES, this.sessionStatesData);
            this.fileStorage.save();
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ Context access$getContext$p(SessionStateStorage $this) {
        return $this.context;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lru/ok/tracer/session/SessionStateStorage$Companion;", "", "()V", "MAX_CUSTOM_PROPERTY_KEY_LENGTH", "", "MAX_CUSTOM_PROPERTY_VALUE_LENGTH", "MAX_SESSIONS", "PROPERTY_KEY_USER_ID", "", "SESSION_START_TS", "SESSION_STATES", "SESSION_STATE_UPLOAD_TS", "SESSION_SYSTEM_STATE", "tracer-commons_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

