/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.utils;

import android.content.Context;
import android.net.Uri;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.base.io.FileUtils;
import ru.ok.tracer.base.process.ProcessUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Lru/ok/tracer/utils/TracerFiles;", "", "()V", "createTempFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "name", "", "getNewSampleFile", "tracerFeature", "Lru/ok/tracer/TracerFeature;", "suffix", "getTracerDir", "tracer-commons_release"})
public final class TracerFiles {
    @NotNull
    public static final TracerFiles INSTANCE = new TracerFiles();

    private TracerFiles() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final File getTracerDir(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String processName = ProcessUtils.getProcessName((Context)context);
        if (Intrinsics.areEqual((Object)processName, (Object)context.getPackageName())) {
            string = "tracer";
        } else {
            void p0;
            String string2 = StringsKt.replace$default((String)processName, (char)':', (char)'-', (boolean)false, (int)4, null);
            StringBuilder stringBuilder = new StringBuilder().append("tracer-");
            boolean bl = false;
            string = stringBuilder.append(Uri.encode((String)p0)).toString();
        }
        String dirName = string;
        return new File(context.getCacheDir(), dirName);
    }

    @NotNull
    public final File getNewSampleFile(@NotNull Context context, @NotNull TracerFeature tracerFeature, @NotNull String suffix) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tracerFeature, (String)"tracerFeature");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return FilesKt.resolve((File)FileUtils.mkdirsChecked((File)this.getTracerDir(context)), (String)(tracerFeature.getName() + '_' + System.currentTimeMillis() + suffix));
    }

    public static /* synthetic */ File getNewSampleFile$default(TracerFiles tracerFiles, Context context, TracerFeature tracerFeature, String string, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            string = ".bin";
        }
        return tracerFiles.getNewSampleFile(context, tracerFeature, string);
    }

    @NotNull
    public final File createTempFile(@NotNull Context context, @NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return FilesKt.resolve((File)FileUtils.mkdirsChecked((File)this.getTracerDir(context)), (String)(name + ".tmp"));
    }

    public static /* synthetic */ File createTempFile$default(TracerFiles tracerFiles, Context context, String string, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string = String.valueOf(System.nanoTime());
        }
        return tracerFiles.createTempFile(context, string);
    }
}

