/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.ok.tracer.Severity;
import ru.ok.tracer.SeverityKt;
import ru.ok.tracer.base.sessionuuuid.SessionUuidUtils;
import ru.ok.tracer.session.SessionState;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a8\u0006\r"}, d2={"Lru/ok/tracer/session/SessionStatesSerializer;", "", "()V", "fromJson", "", "Lru/ok/tracer/session/SessionState;", "string", "", "toJson", "states", "", "toJsonArray", "Lorg/json/JSONArray;", "tracer-commons_release"})
public final class SessionStatesSerializer {
    @NotNull
    public static final SessionStatesSerializer INSTANCE = new SessionStatesSerializer();

    private SessionStatesSerializer() {
    }

    @NotNull
    public final String toJson(@NotNull Iterable<SessionState> states) {
        Intrinsics.checkNotNullParameter(states, (String)"states");
        String string = this.toJsonArray(states).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJsonArray(states).toString()");
        return string;
    }

    @NotNull
    public final JSONArray toJsonArray(@NotNull Iterable<SessionState> states) {
        Intrinsics.checkNotNullParameter(states, (String)"states");
        JSONArray array = new JSONArray();
        for (SessionState state : states) {
            JSONObject obj = new JSONObject();
            obj.put("versionName", (Object)state.getVersionName());
            obj.put("versionCode", state.getVersionCode());
            obj.put("environment", (Object)state.getEnvironment());
            obj.put("sessionUuid", (Object)state.getSessionUuid());
            obj.put("processName", (Object)state.getProcessName());
            obj.put("status", (Object)state.getStatus().toString());
            Severity severity = state.getMaxSeverity();
            obj.put("maxSeverity", (Object)(severity != null ? SeverityKt.toApiString(severity) : null));
            obj.put("isInBackground", state.isInBackground());
            array.put((Object)obj);
        }
        return array;
    }

    @NotNull
    public final List<SessionState> fromJson(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        JSONArray array = new JSONArray(string);
        List states = new ArrayList();
        int n = array.length();
        for (int i = 0; i < n; ++i) {
            Severity severity;
            String string2;
            Object object;
            String string3;
            JSONObject obj = array.getJSONObject(i);
            Collection collection = states;
            String string4 = obj.getString("versionName");
            long l = obj.getLong("versionCode");
            String p0 = string3 = obj.optString("environment", "");
            boolean bl = false;
            String string5 = ((CharSequence)p0).length() > 0 ? string3 : null;
            String p02 = object = obj.optString("sessionUuid", "");
            boolean bl2 = false;
            String string6 = ((CharSequence)p02).length() > 0 ? object : null;
            if (string6 == null) {
                string6 = SessionUuidUtils.createSessionUuid();
            }
            string3 = string6;
            p02 = object = obj.optString("processName", "");
            boolean bl3 = false;
            String string7 = ((CharSequence)p02).length() > 0 ? object : null;
            String p03 = obj.getString("status");
            boolean bl4 = false;
            object = SessionState.Status.valueOf(p03);
            String p04 = string2 = obj.optString("maxSeverity", "");
            boolean bl5 = false;
            String string8 = ((CharSequence)p04).length() > 0 ? string2 : null;
            if (string8 != null) {
                string2 = string8;
                Severity.Companion companion = Severity.Companion;
                String p05 = string2;
                boolean bl6 = false;
                severity = SeverityKt.fromApiString(companion, p05);
            } else {
                severity = null;
            }
            Severity severity2 = severity;
            boolean bl7 = obj.optBoolean("isInBackground");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(\"versionName\")");
            collection.add(new SessionState(l, string4, string5, string3, string7, (SessionState.Status)((Object)object), severity2, bl7));
        }
        return states;
    }
}

