/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.startup;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.base.apptoken.AppTokenUtils;
import ru.ok.tracer.base.compat.PackageManagerCompat;
import ru.ok.tracer.startup.Initializer;
import ru.ok.tracer.utils.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0007J,\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\f2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\r0\u00100\u000fH\u0002J.\u0010\u0011\u001a\u00020\t2\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00132\u0012\u0010\u0014\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\r0\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lru/ok/tracer/startup/TracerStartup;", "", "()V", "META_DATA_PREFIX", "", "prevAppContext", "Ljava/util/concurrent/atomic/AtomicReference;", "Landroid/content/Context;", "init", "", "context", "orderInitializers", "", "Lru/ok/tracer/startup/Initializer;", "initializerClasses", "", "Ljava/lang/Class;", "orderInitializersInto", "orderedInitializers", "", "initializerClass", "tracer-commons_release"})
public final class TracerStartup {
    @NotNull
    public static final TracerStartup INSTANCE = new TracerStartup();
    @NotNull
    private static final String META_DATA_PREFIX = "ru.ok.tracer.startup.Initializer@";
    @NotNull
    private static final AtomicReference<Context> prevAppContext = new AtomicReference();

    private TracerStartup() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void init(@NotNull Context context) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        if (context2 == null) {
            boolean $i$a$-requireNotNull-TracerStartup$init$appContext$22 = false;
            String $i$a$-requireNotNull-TracerStartup$init$appContext$22 = "applicationContext required";
            throw new IllegalArgumentException($i$a$-requireNotNull-TracerStartup$init$appContext$22.toString());
        }
        Context appContext = context2;
        boolean firstCall = prevAppContext.compareAndSet(null, appContext);
        if (!firstCall) {
            if (!(appContext == prevAppContext.get())) {
                boolean $i$a$-check-TracerStartup$init$22 = false;
                String $i$a$-check-TracerStartup$init$22 = "Trying to initialize again with different app context";
                throw new IllegalStateException($i$a$-check-TracerStartup$init$22.toString());
            }
            return;
        }
        if (AppTokenUtils.isTracerBuildDisabled((Context)context)) {
            Logger.d$default("Tracer disabled on build. Skipping initialization", null, 2, null);
            Tracer.disable();
            return;
        }
        PackageManager packageManager = appContext.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"appContext\n            .packageManager");
        String string = appContext.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"appContext.packageName");
        Bundle metaData = PackageManagerCompat.getApplicationInfoCompat((PackageManager)packageManager, (String)string, (int)128).metaData;
        Iterable iterable = CollectionsKt.createListBuilder();
        Object $this$init_u24lambda_u242 = iterable;
        boolean bl = false;
        for (String key : metaData.keySet()) {
            String value;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            if (!StringsKt.startsWith$default((String)key, (String)META_DATA_PREFIX, (boolean)false, (int)2, null) || metaData.getString(key) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"metaData.getString(key) ?: continue");
            Collection collection = (Collection)$this$init_u24lambda_u242;
            Class<?> clazz = Class.forName(value);
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<out ru.ok.tracer.startup.Initializer<*>>");
            collection.add(clazz);
        }
        List initializerClasses = CollectionsKt.build((List)iterable);
        if (initializerClasses.isEmpty()) {
            Logger.e$default("Couldn't find initializer classes. Did you remove it from manifest", null, 2, null);
            return;
        }
        iterable = initializerClasses;
        $this$init_u24lambda_u242 = INSTANCE;
        Collection p0 = iterable;
        boolean bl2 = false;
        iterable = super.orderInitializers(p0);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Initializer it = (Initializer)element$iv;
            boolean bl3 = false;
            it.create(appContext);
        }
    }

    private final List<Initializer<?>> orderInitializers(Collection<? extends Class<? extends Initializer<?>>> initializerClasses) {
        List list;
        List $this$orderInitializers_u24lambda_u244 = list = CollectionsKt.createListBuilder((int)initializerClasses.size());
        boolean bl = false;
        for (Class<Initializer<?>> clazz : initializerClasses) {
            INSTANCE.orderInitializersInto($this$orderInitializers_u24lambda_u244, clazz);
        }
        return CollectionsKt.build((List)list);
    }

    private final void orderInitializersInto(List<Initializer<?>> orderedInitializers, Class<? extends Initializer<?>> initializerClass) {
        boolean bl;
        block5: {
            Iterable $this$any$iv = orderedInitializers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Initializer it = (Initializer)element$iv;
                    boolean bl2 = false;
                    if (!(it.getClass() == initializerClass)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Initializer<?> initializer = initializerClass.newInstance();
        for (Class<Initializer<?>> dependencyClass : initializer.dependencies()) {
            this.orderInitializersInto(orderedInitializers, dependencyClass);
        }
        ((Collection)orderedInitializers).add(initializer);
    }
}

