/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerThreads;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u0000 .2\u00020\u0001:\u0001.B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0010\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\tJ\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bH\u0002J\u001c\u0010\u001d\u001a\u00020\u001e2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bJ\u001d\u0010 \u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010$J\u001d\u0010%\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010&J\u001a\u0010'\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0002J\u001d\u0010(\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\tJ\u000e\u0010+\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010,\u001a\u00020\u001eJ\b\u0010-\u001a\u00020\u001eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006/"}, d2={"Lru/ok/tracer/utils/SimpleFileKeyValueStorage;", "", "fileSupplier", "Lkotlin/Function0;", "Ljava/io/File;", "(Lkotlin/jvm/functions/Function0;)V", "map", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "getMap", "()Ljava/util/concurrent/atomic/AtomicReference;", "map$delegate", "Lkotlin/Lazy;", "getBoolean", "", "key", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getFloat", "", "(Ljava/lang/String;)Ljava/lang/Float;", "getInt", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getLong", "", "(Ljava/lang/String;)Ljava/lang/Long;", "getString", "init", "putAll", "", "values", "putBoolean", "value", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "putFloat", "(Ljava/lang/String;Ljava/lang/Float;)V", "putInt", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/Object;", "putInternal", "putLong", "(Ljava/lang/String;Ljava/lang/Long;)V", "putString", "remove", "save", "writeMap", "Companion", "tracer-commons_release"})
public final class SimpleFileKeyValueStorage {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<File> fileSupplier;
    @NotNull
    private final Lazy map$delegate;
    @Deprecated
    private static final int TYPE_STRING = 1;
    @Deprecated
    private static final int TYPE_BOOLEAN = 2;
    @Deprecated
    private static final int TYPE_INT = 3;
    @Deprecated
    private static final int TYPE_LONG = 4;
    @Deprecated
    private static final int TYPE_FLOAT = 5;
    @Deprecated
    private static final int TYPE_DOUBLE = 6;
    @Deprecated
    private static final int LEGACY_TYPE_CONDITIONS = 7;
    @Deprecated
    private static final int VERSION = 1;

    public SimpleFileKeyValueStorage(@NotNull Function0<? extends File> fileSupplier) {
        Intrinsics.checkNotNullParameter(fileSupplier, (String)"fileSupplier");
        this.fileSupplier = fileSupplier;
        this.map$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AtomicReference<Map<String, ? extends Object>>>(this){
            final /* synthetic */ SimpleFileKeyValueStorage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AtomicReference<Map<String, Object>> invoke() {
                return new AtomicReference<Map<String, Object>>(SimpleFileKeyValueStorage.access$init(this.this$0));
            }
        }));
    }

    private final AtomicReference<Map<String, Object>> getMap() {
        Lazy lazy = this.map$delegate;
        return (AtomicReference)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> init() {
        try {
            Map map2;
            File file = (File)this.fileSupplier.invoke();
            if (!file.exists()) {
                return MapsKt.emptyMap();
            }
            Closeable closeable = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            Throwable throwable = null;
            try {
                Map map3;
                DataInputStream it = (DataInputStream)closeable;
                boolean bl = false;
                int version = it.readInt();
                if (version > 1) {
                    map3 = MapsKt.emptyMap();
                } else {
                    int records = it.readInt();
                    Object[] objectArray = new Object[]{records};
                    Logger.d("R records: %s", objectArray);
                    Map out = new LinkedHashMap();
                    int i = 1;
                    if (i <= records) {
                        while (true) {
                            Object object;
                            String key = it.readUTF();
                            int typeInt = it.readInt();
                            switch (typeInt) {
                                case 2: {
                                    object = it.readBoolean();
                                    break;
                                }
                                case 3: {
                                    object = it.readInt();
                                    break;
                                }
                                case 4: {
                                    object = it.readLong();
                                    break;
                                }
                                case 5: {
                                    object = Float.valueOf(it.readFloat());
                                    break;
                                }
                                case 6: {
                                    object = it.readDouble();
                                    break;
                                }
                                case 1: {
                                    object = it.readUTF();
                                    break;
                                }
                                case 7: {
                                    SimpleFileKeyValueStorage.Companion.skipLegacyConditions(it);
                                    object = Unit.INSTANCE;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Read unknown type " + typeInt + " with key " + key);
                                }
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when (typeInt) {\n       \u2026y\")\n                    }");
                            Object value = object;
                            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                            out.put(key, value);
                            Object[] objectArray2 = new Object[]{key, value};
                            Logger.d("R property %s = %s", objectArray2);
                            if (i == records) break;
                            ++i;
                        }
                    }
                    map3 = out;
                }
                map2 = map3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return map2;
        }
        catch (Exception e) {
            Logger.e(e);
            return MapsKt.emptyMap();
        }
    }

    public final void putString(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.putInternal(key, value);
    }

    public final void putBoolean(@NotNull String key, @Nullable Boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.putInternal(key, value);
    }

    @NotNull
    public final Object putInt(@NotNull String key, @Nullable Integer value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.putInternal(key, value);
        return Unit.INSTANCE;
    }

    public final void putLong(@NotNull String key, @Nullable Long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.putInternal(key, value);
    }

    public final void putFloat(@NotNull String key, @Nullable Float value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.putInternal(key, value);
    }

    @Nullable
    public final String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (String)this.getMap().get().get(key);
    }

    @Nullable
    public final Boolean getBoolean(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (Boolean)this.getMap().get().get(key);
    }

    @Nullable
    public final Integer getInt(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (Integer)this.getMap().get().get(key);
    }

    @Nullable
    public final Long getLong(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (Long)this.getMap().get().get(key);
    }

    @Nullable
    public final Float getFloat(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (Float)this.getMap().get().get(key);
    }

    public final void putAll(@NotNull Map<String, ? extends Object> values) {
        Map map2;
        Map newOne$iv;
        Map<String, Object> oldOne$iv;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        AtomicReference<Map<String, Object>> $this$update$iv = this.getMap();
        boolean $i$f$update = false;
        do {
            oldOne$iv = $this$update$iv.get();
            Intrinsics.checkNotNullExpressionValue(oldOne$iv, (String)"oldOne");
            Map it = map2 = MapsKt.toMutableMap(oldOne$iv);
            boolean bl = false;
            for (Map.Entry<String, ? extends Object> entry : values.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) {
                    it.remove(key);
                    continue;
                }
                it.put(key, value);
            }
        } while (!$this$update$iv.compareAndSet(oldOne$iv, newOne$iv = map2));
    }

    private final void putInternal(String key, Object value) {
        Map map2;
        Map newOne$iv;
        Map<String, Object> oldOne$iv;
        AtomicReference<Map<String, Object>> $this$update$iv = this.getMap();
        boolean $i$f$update = false;
        do {
            oldOne$iv = $this$update$iv.get();
            Intrinsics.checkNotNullExpressionValue(oldOne$iv, (String)"oldOne");
            Map it = map2 = MapsKt.toMutableMap(oldOne$iv);
            boolean bl = false;
            if (value == null) {
                it.remove(key);
                continue;
            }
            it.put(key, value);
        } while (!$this$update$iv.compareAndSet(oldOne$iv, newOne$iv = map2));
    }

    public final void remove(@NotNull String key) {
        Map map2;
        Map newOne$iv;
        Map<String, Object> oldOne$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        AtomicReference<Map<String, Object>> $this$update$iv = this.getMap();
        boolean $i$f$update = false;
        do {
            oldOne$iv = $this$update$iv.get();
            Intrinsics.checkNotNullExpressionValue(oldOne$iv, (String)"oldOne");
            Map it = map2 = MapsKt.toMutableMap(oldOne$iv);
            boolean bl = false;
            it.remove(key);
        } while (!$this$update$iv.compareAndSet(oldOne$iv, newOne$iv = map2));
    }

    public final void save() {
        TracerThreads.INSTANCE.runInBgSequential(this::writeMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeMap() {
        try {
            Map<String, Object> map2 = this.getMap().get();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"map.get()");
            Map mapToWrite = MapsKt.toMap(map2);
            Closeable closeable = new DataOutputStream(new BufferedOutputStream(new FileOutputStream((File)this.fileSupplier.invoke())));
            Throwable throwable = null;
            try {
                DataOutputStream out = (DataOutputStream)closeable;
                boolean bl = false;
                out.writeInt(1);
                out.writeInt(mapToWrite.size());
                Map $this$forEach$iv = mapToWrite;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    out.writeUTF((String)it.getKey());
                    Object value = it.getValue();
                    if (value instanceof Boolean) {
                        out.writeInt(2);
                        out.writeBoolean((Boolean)value);
                        continue;
                    }
                    if (value instanceof Integer) {
                        out.writeInt(3);
                        out.writeInt(((Number)value).intValue());
                        continue;
                    }
                    if (value instanceof Long) {
                        out.writeInt(4);
                        out.writeLong(((Number)value).longValue());
                        continue;
                    }
                    if (value instanceof Float) {
                        out.writeInt(5);
                        out.writeFloat(((Number)value).floatValue());
                        continue;
                    }
                    if (value instanceof Double) {
                        out.writeInt(6);
                        out.writeDouble(((Number)value).doubleValue());
                        continue;
                    }
                    if (value instanceof String) {
                        out.writeInt(1);
                        out.writeUTF((String)value);
                        continue;
                    }
                    throw new IllegalArgumentException("Write unknown type of value " + value);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Logger.e("Failed to write settings", e);
        }
    }

    public static final /* synthetic */ Map access$init(SimpleFileKeyValueStorage $this) {
        return $this.init();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lru/ok/tracer/utils/SimpleFileKeyValueStorage$Companion;", "", "()V", "LEGACY_TYPE_CONDITIONS", "", "TYPE_BOOLEAN", "TYPE_DOUBLE", "TYPE_FLOAT", "TYPE_INT", "TYPE_LONG", "TYPE_STRING", "VERSION", "skipLegacyConditions", "", "inStream", "Ljava/io/DataInputStream;", "tracer-commons_release"})
    private static final class Companion {
        private Companion() {
        }

        private final void skipLegacyConditions(DataInputStream inStream) {
            int version = inStream.readInt();
            int size = inStream.readInt();
            for (int i = 0; i < size; ++i) {
                inStream.readUTF();
                inStream.readLong();
                inStream.readUTF();
                inStream.readUTF();
                inStream.readLong();
                if (version != 1) continue;
                inStream.readInt();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

