/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.utils;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Executor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.utils.TracerThreads;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lru/ok/tracer/utils/TracerThreads;", "", "()V", "bgExecutor", "Ljava/util/concurrent/Executor;", "getBgExecutor", "()Ljava/util/concurrent/Executor;", "bgExecutor$delegate", "Lkotlin/Lazy;", "ioExecutor", "getIoExecutor", "ioExecutor$delegate", "runInBgAfterStartup", "", "runnable", "Ljava/lang/Runnable;", "runInBgSequential", "runOnIo", "tracer-commons_release"})
public final class TracerThreads {
    @NotNull
    public static final TracerThreads INSTANCE = new TracerThreads();
    @NotNull
    private static final Lazy ioExecutor$delegate = LazyKt.lazy((Function0)ioExecutor.2.INSTANCE);
    @NotNull
    private static final Lazy bgExecutor$delegate = LazyKt.lazy((Function0)bgExecutor.2.INSTANCE);

    private TracerThreads() {
    }

    private final Executor getIoExecutor() {
        Lazy lazy = ioExecutor$delegate;
        return (Executor)lazy.getValue();
    }

    private final Executor getBgExecutor() {
        Lazy lazy = bgExecutor$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-bgExecutor>(...)");
        return (Executor)object;
    }

    public final void runOnIo(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.getIoExecutor().execute(runnable);
    }

    public final void runInBgSequential(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.getBgExecutor().execute(runnable);
    }

    public final void runInBgAfterStartup(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        new Handler(Looper.getMainLooper()).post(() -> TracerThreads.runInBgAfterStartup$lambda$0(runnable));
    }

    private static final void runInBgAfterStartup$lambda$0(Runnable $runnable) {
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        INSTANCE.runInBgSequential($runnable);
    }
}

