/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.session;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.base.io.FileUtils;
import ru.ok.tracer.session.TagsStorageKt;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;
import ru.ok.tracer.utils.TracerThreads;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J#\u0010\u0019\u001a\u00020\u00162\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001bH\u0000\u00a2\u0006\u0002\b\u001cR\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lru/ok/tracer/session/TagsStorage;", "", "context", "Landroid/content/Context;", "maxKeysCount", "", "(Landroid/content/Context;I)V", "applicationContext", "lock", "prevTags", "", "", "getPrevTags", "()Ljava/util/List;", "prevTagsData", "prevTagsState", "Lru/ok/tracer/session/TagsStorage$PrevTagsState;", "tags", "getTags", "tagsData", "", "clearPrevTags", "", "ensurePrevTagsState", "toPrevTagsState", "setKeys", "map", "", "setKeys$tracer_commons_release", "Companion", "PrevTagsState", "tracer-commons_release"})
public final class TagsStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxKeysCount;
    @NotNull
    private final Context applicationContext;
    @NotNull
    private final Object lock;
    @NotNull
    private volatile PrevTagsState prevTagsState;
    @Nullable
    private List<String> prevTagsData;
    @NotNull
    private final List<String> tagsData;
    @NotNull
    private static final String FILE_TAGS = "tags";

    public TagsStorage(@NotNull Context context, int maxKeysCount) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.maxKeysCount = maxKeysCount;
        Context context2 = context.getApplicationContext();
        if (context2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.applicationContext = context2;
        this.lock = new Object();
        this.prevTagsState = PrevTagsState.NONE;
        this.tagsData = new ArrayList();
    }

    public /* synthetic */ TagsStorage(Context context, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 30;
        }
        this(context, n);
    }

    @NotNull
    public final List<String> getPrevTags() {
        this.ensurePrevTagsState(PrevTagsState.LOADED);
        List<String> list = this.prevTagsData;
        if (list == null) {
            boolean bl = false;
            String string = "Cannot get prev tags after clear";
            throw new IllegalStateException(string.toString());
        }
        return list;
    }

    public final void clearPrevTags() {
        this.ensurePrevTagsState(PrevTagsState.CLEAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensurePrevTagsState(PrevTagsState toPrevTagsState) {
        PrevTagsState oldPrevTagsState = this.prevTagsState;
        if (oldPrevTagsState.compareTo((Enum)toPrevTagsState) >= 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            PrevTagsState syncPrevTagsState = this.prevTagsState;
            if (syncPrevTagsState.compareTo((Enum)toPrevTagsState) >= 0) {
                return;
            }
            File tagsFile = FilesKt.resolve((File)TracerFiles.INSTANCE.getTracerDir(this.applicationContext), (String)FILE_TAGS);
            block2 : switch (WhenMappings.$EnumSwitchMapping$0[syncPrevTagsState.ordinal()]) {
                case 3: {
                    switch (WhenMappings.$EnumSwitchMapping$0[toPrevTagsState.ordinal()]) {
                        case 1: {
                            List readTagsData;
                            this.prevTagsData = readTagsData = TagsStorageKt.access$readTags(tagsFile);
                            break block2;
                        }
                        case 2: {
                            TagsStorage.Companion.deleteIfExists(tagsFile);
                            break block2;
                        }
                    }
                    throw new AssertionError((Object)"Unreachable code");
                }
                case 1: {
                    if (WhenMappings.$EnumSwitchMapping$0[toPrevTagsState.ordinal()] == 2) {
                        TagsStorage.Companion.deleteIfExists(tagsFile);
                        this.prevTagsData = null;
                        break;
                    }
                    throw new AssertionError((Object)"Unreachable code");
                }
                default: {
                    throw new AssertionError((Object)"Unreachable code");
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> getTags() {
        List list;
        List<String> list2 = this.tagsData;
        synchronized (list2) {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)this.tagsData);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setKeys$tracer_commons_release(@NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        boolean updated = false;
        List<String> list = this.tagsData;
        synchronized (list) {
            boolean bl = false;
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                updated |= Companion.putTag$tracer_commons_release(this.tagsData, key, value, this.maxKeysCount);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (!updated) {
            return;
        }
        TracerThreads.INSTANCE.runInBgSequential(() -> TagsStorage.setKeys$lambda$4(this));
    }

    private static final void setKeys$lambda$4(TagsStorage this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.ensurePrevTagsState(PrevTagsState.LOADED);
        try {
            File tracerDir = TracerFiles.INSTANCE.getTracerDir(this$0.applicationContext);
            FileUtils.mkdirsChecked((File)tracerDir);
            File tagsFile = FilesKt.resolve((File)tracerDir, (String)FILE_TAGS);
            TagsStorageKt.access$writeTags(tagsFile, this$0.getTags());
        }
        catch (Exception ex) {
            Logger.e("Cannot write tags", ex);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J7\u0010\u0011\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\u0012J\u001e\u0010\u0013\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lru/ok/tracer/session/TagsStorage$Companion;", "", "()V", "FILE_TAGS", "", "addTag", "", "tags", "", "rawKey", "rawValue", "limit", "", "deleteIfExists", "", "file", "Ljava/io/File;", "putTag", "putTag$tracer_commons_release", "removeTag", "tracer-commons_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final boolean putTag$tracer_commons_release(@NotNull List<String> tags, @NotNull String rawKey, @Nullable String rawValue, int limit) {
            Intrinsics.checkNotNullParameter(tags, (String)TagsStorage.FILE_TAGS);
            Intrinsics.checkNotNullParameter((Object)rawKey, (String)"rawKey");
            return rawValue != null ? this.addTag(tags, rawKey, rawValue, limit) : this.removeTag(tags, rawKey);
        }

        public static /* synthetic */ boolean putTag$tracer_commons_release$default(Companion companion, List list, String string, String string2, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = 30;
            }
            return companion.putTag$tracer_commons_release(list, string, string2, n);
        }

        private final boolean addTag(List<String> tags, String rawKey, String rawValue, int limit) {
            String key = StringsKt.take((String)rawKey, (int)31);
            int keyLength = key.length();
            String value = StringsKt.take((String)rawValue, (int)31);
            Iterator<String> i = tags.iterator();
            while (i.hasNext()) {
                String tag = i.next();
                if (!StringsKt.startsWith$default((String)tag, (String)key, (boolean)false, (int)2, null) || tag.length() <= keyLength || tag.charAt(keyLength) != '=') continue;
                i.remove();
                if (!StringsKt.endsWith$default((String)tag, (String)value, (boolean)false, (int)2, null) || tag.length() != keyLength + value.length() + 1) break;
                ((Collection)tags).add(tag);
                return false;
            }
            ((Collection)tags).add(key + '=' + value);
            while (tags.size() > limit) {
                tags.remove(0);
            }
            return true;
        }

        static /* synthetic */ boolean addTag$default(Companion companion, List list, String string, String string2, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = 30;
            }
            return companion.addTag(list, string, string2, n);
        }

        private final boolean removeTag(List<String> tags, String rawKey) {
            String key = StringsKt.take((String)rawKey, (int)31);
            int keyLength = key.length();
            Iterator<String> i = tags.iterator();
            while (i.hasNext()) {
                String tag = i.next();
                if (!StringsKt.startsWith$default((String)tag, (String)key, (boolean)false, (int)2, null) || tag.length() <= keyLength || tag.charAt(keyLength) != '=') continue;
                i.remove();
                return true;
            }
            return false;
        }

        private final void deleteIfExists(File file) {
            if (!file.exists()) {
                return;
            }
            try {
                FileUtils.deleteChecked((File)file);
            }
            catch (IOException ex) {
                Logger.e("Cannot delete file " + file, ex);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lru/ok/tracer/session/TagsStorage$PrevTagsState;", "", "(Ljava/lang/String;I)V", "NONE", "LOADED", "CLEAN", "tracer-commons_release"})
    private static final class PrevTagsState
    extends Enum<PrevTagsState> {
        public static final /* enum */ PrevTagsState NONE = new PrevTagsState();
        public static final /* enum */ PrevTagsState LOADED = new PrevTagsState();
        public static final /* enum */ PrevTagsState CLEAN = new PrevTagsState();
        private static final /* synthetic */ PrevTagsState[] $VALUES;

        public static PrevTagsState[] values() {
            return (PrevTagsState[])$VALUES.clone();
        }

        public static PrevTagsState valueOf(String value) {
            return Enum.valueOf(PrevTagsState.class, value);
        }

        static {
            $VALUES = prevTagsStateArray = new PrevTagsState[]{PrevTagsState.NONE, PrevTagsState.LOADED, PrevTagsState.CLEAN};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PrevTagsState.values().length];
            try {
                nArray[PrevTagsState.LOADED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrevTagsState.CLEAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrevTagsState.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

